% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kersplat-simulate.R
\name{kersplatSample}
\alias{kersplatSample}
\title{Kersplat sample}
\usage{
kersplatSample(params, sparsify = TRUE, verbose = TRUE)
}
\arguments{
\item{params}{KersplatParams object containing simulation parameters.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages}
}
\value{
SingleCellExperiment object containing the simulated counts and
intermediate values.
}
\description{
Sample cells for the Kersplat simulation
}
\details{
The second stage is a two-step Kersplat simulation is to generate cells based
on a complete \code{\link{KersplatParams}} object.
intermediate parameters.

The sampling process involves the following steps:
\enumerate{
    \item Simulate library sizes for each cell
    \item Simulate means for each cell
    \item Simulate endogenous counts for each cell
    \item Simulate ambient counts for each cell
    \item Simulate final counts for each cell
}

The final output is a
\code{\link[SingleCellExperiment]{SingleCellExperiment}} object that
contains the simulated counts but also the values for various intermediate
steps. These are stored in the \code{\link[SummarizedExperiment]{colData}}
(for cell specific information), \code{\link[SummarizedExperiment]{rowData}}
(for gene specific information) or \code{\link[SummarizedExperiment]{assays}}
(for gene by cell matrices) slots. This additional information includes:

\describe{
    \item{\code{colData}}{
        \describe{
            \item{Cell}{Unique cell identifier.}
            \item{Type}{Whether the cell is a Cell, Doublet or Empty.}
            \item{CellLibSize}{The expected number of endogenous counts for
            that cell.}
            \item{AmbientLibSize}{The expected number of ambient counts for
            that cell.}
            \item{Path}{The path the cell belongs to.}
            \item{Step}{How far along the path each cell is.}
            \item{Path1}{For doublets the path of the first partner in the
            doublet (otherwise \code{NA}).}
            \item{Step1}{For doublets the step of the first partner in the
            doublet (otherwise \code{NA}).}
            \item{Path2}{For doublets the path of the second partner in the
            doublet (otherwise \code{NA}).}
            \item{Step2}{For doublets the step of the second partner in the
            doublet (otherwise \code{NA}).}
        }
    }
    \item{\code{rowData}}{
        \describe{
            \item{Gene}{Unique gene identifier.}
            \item{BaseMean}{The base expression level for that gene.}
            \item{AmbientMean}{The ambient expression level for that gene.}
        }
    }
    \item{\code{assays}}{
        \describe{
            \item{CellMeans}{The mean expression of genes in each cell
            after any differential expression and adjusted for expected
            library size.}
            \item{CellCounts}{Endogenous count matrix.}
            \item{AmbientCounts}{Ambient count matrix.}
            \item{counts}{Final count matrix.}
        }
    }
}

Values that have been added by Splatter are named using \code{UpperCamelCase}
in order to differentiate them from the values added by analysis packages
which typically use \code{underscore_naming}.
}
\examples{

if (requireNamespace("igraph", quietly = TRUE)) {
    params <- kersplatSetup()
    sim <- kersplatSample(params)
}
}
\seealso{
\code{\link{kersplatSimLibSizes}}, \code{\link{kersplatSimCellMeans}},
\code{\link{kersplatSimCellCounts}}, \code{\link{kersplatSimAmbientCounts}},
\code{\link{kersplatSimCounts}}
}
