% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BASiCS-simulate.R
\name{BASiCSSimulate}
\alias{BASiCSSimulate}
\title{BASiCS simulation}
\usage{
BASiCSSimulate(
  params = newBASiCSParams(),
  sparsify = TRUE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{params}{BASiCSParams object containing simulation parameters.}

\item{sparsify}{logical. Whether to automatically convert assays to sparse
matrices if there will be a size reduction.}

\item{verbose}{logical. Whether to print progress messages}

\item{...}{any additional parameter settings to override what is provided in
\code{params}.}
}
\value{
SingleCellExperiment containing simulated counts
}
\description{
Simulate counts using the BASiCS method.
}
\details{
This function is just a wrapper around \code{\link[BASiCS]{BASiCS_Sim}} that
takes a \code{\link{BASiCSParams}}, runs the simulation then converts the
output to a \code{\link[SingleCellExperiment]{SingleCellExperiment}} object.
See \code{\link[BASiCS]{BASiCS_Sim}} for more details of how the simulation
works.
}
\examples{
if (requireNamespace("BASiCS", quietly = TRUE)) {
    sim <- BASiCSSimulate()
}
}
\references{
Vallejos CA, Marioni JC, Richardson S. BASiCS: Bayesian Analysis of
Single-Cell Sequencing data. PLoS Computational Biology (2015).

Paper: \url{10.1371/journal.pcbi.1004333}

Code: \url{https://github.com/catavallejos/BASiCS}
}
