% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_merged_gr.R
\name{get_merged_gr}
\alias{get_merged_gr}
\title{get a GRanges of (by default, standard) chromosomes from seqinfo}
\usage{
get_merged_gr(si, spike, standard = TRUE)
}
\arguments{
\item{si}{seqinfo, usually from a BAM/CRAM file with spike contigs}

\item{spike}{database of spike-in standard sequence features (spike)}

\item{standard}{trim to standard chromosomes? (TRUE)}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     GRanges with two genomes: the organism assembly and "spike"
}\if{html}{\out{</div>}}
}
\description{
refactored from scan_spiked_bam to clarify information flow
}
\details{
By default, get_merged_gr will return a GRanges with "standardized"
genomic and spike contig names (i.e. genomic chr1-22, X, Y, M, and
the canonical spike names in data(spike, package="spiky")).

The constraint to "standard" chromosomes on genomic contigs can be
removed by setting \code{standard} to FALSE in the function arguments.
}
\examples{
sb <- system.file("extdata", "example.spike.bam", package="spiky", 
                  mustWork=TRUE) 
si <- seqinfo_from_header(sb) 
genome(si) <- "spike" # no genomic contigs
data(spike, package="spiky")
get_merged_gr(si, spike=spike) # note canonicalized spikes

}
