% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edit_tar.R
\name{edit_tar}
\alias{edit_tar}
\title{Edit Targets Files}
\usage{
edit_tar(df.tar, column, old, new, sub.row)
}
\arguments{
\item{df.tar}{The data frame of a targets file.}

\item{column}{The column to edit, either the column name or an integer of the column index.}

\item{old}{A vector of existing entries to replace, where the length must be the same with \code{new}.}

\item{new}{A vector of desired entries to replace that in \code{old}, where each entry corresponds to a counterpart in \code{old} respectively.}

\item{sub.row}{A vector of integers corresponding to target rows for editing, or a vector of TRUE and FALSE corresponding to each row. Default is all rows in the targets file.}
}
\value{
A \code{data.frame}.
}
\description{
Replace existing entries in a chosen column of a targets file with desired ones.
}
\examples{
sh.tar <- system.file('extdata/shinyApp/data/target_arab.txt', package='spatialHeatmap')
target.sh <- read_fr(sh.tar)
target.sh.new <- edit_tar(df.tar=target.sh, column='conditions', old=c('control', 'hypoxia'),
new=c('C', 'H'), sub.row=c(1:12))
}
\references{
Mustroph, Angelika, M Eugenia Zanetti, Charles J H Jang, Hans E Holtan, Peter P Repetti, David W Galbraith, Thomas Girke, and Julia Bailey-Serres. 2009. “Profiling Translatomes of Discrete Cell Populations Resolves Altered Cellular Priorities During Hypoxia in Arabidopsis.” Proc Natl Acad Sci U S A 106 (44): 18843–8
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
