% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_shiny.R
\name{custom_shiny}
\alias{custom_shiny}
\title{Create Customized spatialHeatmap Shiny Apps}
\usage{
custom_shiny(
  data = NULL,
  db = NULL,
  lis.par = NULL,
  par.tmp = FALSE,
  dld.sgl = NULL,
  dld.mul = NULL,
  dld.vars = NULL,
  data.tmp = TRUE,
  ldg = NULL,
  gallery = NULL,
  about = NULL,
  app.dir = "."
)
}
\arguments{
\item{data}{A nested `list` of custom data and aSVG files that will be the pre-included examples in the custom App. File paths of each data-aSVG pair should be included in a `list` that have four slots: `name`, `display`, `data`, and `svg`, e.g. `lis1 <- list(name='mus.brain', display='Mouse brain (SHM)', data='./mus_brain.txt', svg='./mus_brain.svg')`. The `name` will be syntactically valide for R code, while the `display` will be shown on the user interface, so the latter can include special characters. The `data` and `svg` is the file path of numeric data and corresponding aSVG respectively. If multiple aSVGs (e.g. growth stages) correspond to a single numeric data set, the respective paths will be stored in a vector in the `svg` slot (see example below). After store the data-aSVG pairs in separate `list`s, store these `list`s in another `list` (nested `list`), e.g. `list(lis1, lis2)`. The data and aSVGs in the nested `list` will be copied to the `data` folder in the custom App.}

\item{db}{Paired assay data and aSVGs in a tar file that will be used as a backend database. See \code{\link{write_hdf5}}.}

\item{lis.par}{A `list` of custom parameters of the Shiny App that will be the default when the custom App is launched. See \code{par.tmp}. Default is `NULL` and the default parameters in the spatialHeatmap Shiny App will be inherited.}

\item{par.tmp}{Logical. If `TRUE` the default paramters in the spatialHeatmap Shiny App are returned in a `list`, and users can edit these settings then assign the `list` back to \code{lis.par}. Note, only the existing values in the `list` can be edited and the hierarchy of the `list` should be preserved. Otherwise, it cannot be recognized by the internal program.}

\item{dld.sgl}{A `list` of paired data matrix and single aSVG file, which would be downloadable example dataset on the App for testing. The `list` consists of paths of the data matrix and aSVG file with name slots of `data` and `svg` respectively, e.g. \code{list(data='./data_download.txt', svg='./root_download_shm.svg')}. The specified data and aSVG will copied to the `data` folder in the App.}

\item{dld.mul}{A `list` of paired data matrix and multiple aSVG files, which would be downloadable example dataset on the App for testing. It is the same as `dld.sgl` except that in the `svg` slot, multiple aSVG file paths are stored, e.g. `list(data='./data_download.txt', svg=c('./root_young_download_shm1.svg', './root_old_download_shm2.svg'))`.}

\item{dld.vars}{A `list` of paired data matrix and single aSVG file, which would be downloadable data.tmp dataset on the App for testing. It is the same as `dld.sgl` except that multiple experimental variables are combined in the data matrix (see package viengettes for details.)}

\item{data.tmp}{Logical. If `TRUE` (default), both example data sets in the spatialHeatmap Shiny App and custom data sets in `data` will be included in the custom App.}

\item{ldg, gallery, about}{The paths of ".html" files that will be used for the landing, gallery, and about pages in the custom Shiny App respectively. The default is `NULL`, indicating default ".html" files will be used.}

\item{app.dir}{The directory to create the Shiny App. Default is current work directory \code{.}.}
}
\value{
If \code{par.tmp==TRUE}, the default paramters in spatialHeatmap Shiny App are returned in a `list`. Otherwise, a customized Shiny App is generated in the path of \code{app.dir}.
}
\description{
This function creates customized spatialHeatmap Shiny Apps with user-provided data, aSVG files, and default parameters by using the spatialHeatmap Shiny App as the template.
}
\examples{

# The data sets in spatialHeatmap are used for demonstrations.

## Below are demonstrations of simple usage.
# File paths of one data matrix and one aSVG.
data.path1 <- system.file('extdata/shinyApp/data/expr_mouse.txt', package='spatialHeatmap')
svg.path1 <- system.file('extdata/shinyApp/data/mus_musculus.male.svg', 
package='spatialHeatmap')
# Save the file paths in a list with name slots of "name", "display", "data", and "svg".
lis.dat1 <- list(name='Mouse', display='Mouse (SHM)', data=data.path1, svg=svg.path1)
# Create custom Shiny Apps.
\donttest{
if (!dir.exists('~/test_shiny')) dir.create('~/test_shiny')
# Create custom Shiny app by feeding this function these datasets and parameters.
custom_shiny(data=list(lis.dat1), app.dir='~/test_shiny')
# Lauch the app.
shiny::runApp('~/test_shiny/shinyApp') 
}

## Below are demonstrations of advanced usage. 

# Paths of one data matrix and two aSVGs (two growth stages).
data.path2 <- system.file('extdata/shinyApp/data/random_data_multiple_aSVGs.txt', 
package='spatialHeatmap')
svg.path2.1 <- system.file('extdata/shinyApp/data/arabidopsis.thaliana_organ_shm1.svg', 
package='spatialHeatmap')
svg.path2.2 <- system.file('extdata/shinyApp/data/arabidopsis.thaliana_organ_shm2.svg', 
package='spatialHeatmap')
# Save the file paths in a list with name slots of "name", "display", "data", and "svg".
lis.dat2 <- list(name='growthStage', display='Multiple aSVGs (SHM)',data=data.path2, 
svg=c(svg.path2.1, svg.path2.2))

# Paths of one data matrix with combined variables and one aSVG.
data.path.vars <- system.file('extdata/shinyApp/data/mus_brain_vars_se_shiny.rds', 
package='spatialHeatmap')
svg.path.vars <- system.file('extdata/shinyApp/data/mus_musculus.brain.svg', 
package='spatialHeatmap')
# Save the file paths in a list with name slots of "name", "display", "data", and "svg".
lis.dat.vars <- list(name='multiVariables', display='Multiple variables (SHM)', 
data=data.path.vars, svg=svg.path.vars)

# Paths of one data matrix and one aSVGs for creating downloadable example data sets.
data.path.dld1 <- system.file('extdata/shinyApp/data/expr_mouse.txt', 
package='spatialHeatmap')
svg.path.dld1 <- system.file('extdata/shinyApp/data/mus_musculus.male.svg', 
package='spatialHeatmap')
# Save the file paths in a list with name slots of "name", "display", "data", and "svg".
dld.sgl <- list(data=data.path.dld1, svg=svg.path.dld1)

# For demonstration purpose, the same data and aSVGs are used to make the list for creating 
# downloadable example dataset of two growth stages. 
dld.mul <- list(data=data.path2, svg=c(svg.path2.1, svg.path2.2))

# For demonstration purpose, the same multi-variable data and aSVG are used to create the
# downloadable example multi-variable dataset.
dld.vars <- list(data=data.path.vars, svg=svg.path.vars)

# Retrieve the default parameters in the App template.
lis.par <- custom_shiny(par.tmp=TRUE)
# Change default setting of color scheme in the color key.
lis.par$shm.img['color', ] <- 'yellow,orange,blue'
# The default dataset to show when the app is launched.
lis.par$default.dataset <- 'shoot'

# Store all default data sets in a nested list.
dat.all <- list(lis.dat1, lis.dat2, lis.dat.vars)

# Create custom Shiny Apps.
\donttest{
if (!dir.exists('~/test_shiny')) dir.create('~/test_shiny')
custom_shiny(data=dat.all, lis.par=lis.par, dld.sgl=dld.sgl, dld.mul=dld.mul, dld.vars=dld.vars, 
app.dir='~/test_shiny')
# Lauch the App.
shiny::runApp('~/test_shiny/shinyApp') 
}

# The customized Shiny App is able to take database backend as well. Examples are 
# demonstrated in the function "write_hdf5".

}
\references{
Jeremy Stephens, Kirill Simonov, Yihui Xie, Zhuoer Dong, Hadley Wickham, Jeffrey Horner, reikoch, Will Beasley, Brendan O'Connor and Gregory R. Warnes (2020). yaml: Methods to Convert R Data to YAML and Back. R package version 2.2.1. https://CRAN.R-project.org/package=yaml
\cr Winston Chang, Joe Cheng, JJ Allaire, Yihui Xie and Jonathan McPherson (2017). shiny: Web Application Framework for R. R package version 1.0.3. https://CRAN.R-project.org/package=shiny
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
