% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_kmeans.R
\name{plot_kmeans}
\alias{plot_kmeans}
\title{Plotting the clusters returned by K-means clustering}
\usage{
plot_kmeans(
  data,
  res,
  query,
  dimred = "TSNE",
  title = "Kmeans Clustering Results"
)
}
\arguments{
\item{data}{A numeric \code{data.frame} scaled with \code{scale}.}

\item{res}{The clustering results returned by \code{kmeans}.}

\item{query}{A rowname in \code{data}. The cluster containing this rowname will be labeled.}

\item{dimred}{The dimension reduction method, one of \code{'PCA'}, \code{'UMAP'}, or \code{'TSNE'}.}

\item{title}{The plot title.}
}
\value{
A ggplot.
}
\description{
This function is designed to plot the clusters returned by K-means clustering.
}
\examples{
set.seed(10)
data <- iris[, 1:4]
rownames(data) <- paste0('gene', seq_len(nrow(data)))
dat.scl <- scale(data)
clus <- kmeans(dat.scl, 6)
plot_kmeans(data=dat.scl, res=clus, query='gene1', dimred='TSNE') 
}
\references{
Melville J (2022). _uwot: The Uniform Manifold Approximation and Projection (UMAP) Method for Dimensionality Reduction_. R package version 0.1.14, <https://CRAN.R-project.org/package=uwot>
Jesse H. Krijthe (2015). Rtsne: T-Distributed Stochastic Neighbor Embedding using a Barnes-Hut Implementation, URL: https://github.com/jkrijthe/Rtsne
H. Wickham. ggplot2: Elegant Graphics for Data Analysis. Springer-Verlag New York, 2016.
}
\author{
Jianhai Zhang \email{jzhan067@ucr.edu} \cr Dr. Thomas Girke \email{thomas.girke@ucr.edu}
}
