% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-mgheatmap.R
\name{mgheatmap}
\alias{mgheatmap}
\title{Creates a "geneset smart" ComplexHeatmap::Heatmap}
\usage{
mgheatmap(
  x,
  gdb = NULL,
  col = NULL,
  aggregate.by = c("none", "ewm", "ewz", "zscore"),
  split = TRUE,
  scores = NULL,
  gs.order = NULL,
  name = NULL,
  rm.collection.prefix = TRUE,
  rm.dups = FALSE,
  recenter = FALSE,
  rescale = FALSE,
  center = TRUE,
  scale = TRUE,
  rename.rows = NULL,
  zero_center_colramp = NULL,
  zlim = NULL,
  transpose = FALSE,
  ...
)
}
\arguments{
\item{x}{the data matrix}

\item{gdb}{\code{GeneSetDb} object that holds the genesets to plot. Defaults to
\code{NULL}, which will plot all rows in \code{x}.}

\item{col}{a colorRamp(2) function}

\item{aggregate.by}{the method used to generate single-sample geneset
scores. Default is \code{none} which plots heatmap at the gene level}

\item{split}{introduce row-segmentation based on genesets or collections?
Defaults is \code{TRUE} which will create split heatmaps based on
collection if \code{aggregate.by != 'none'}, or based on gene sets
if \code{aggregate.by == "none"}.}

\item{scores}{If \code{aggregate.by != "none"} you can pass in a precomupted
\code{\link[=scoreSingleSamples]{scoreSingleSamples()}} result, otherwise one will be
computed internally. Note that if this is a \code{data.frame} of
pre-computed scores, the \code{gdb} is largely irrelevant (but still
required).}

\item{gs.order}{This is experimental, and is here to help order the order
of the genesets (or genesets collection) in a different way than the
default. By default, \code{gs.order = NULL} and genesets are enumerated in
alphabetical in the heatmap. You can pass in a character vector that will
dictate the order of the genesets displayed in the heatmap. Currently this
only matches against the \code{"name"} value of the geneset and probably only
works when \code{split = TRUE}. We will support \verb{colleciton,name} tuples soon.
This can be a superset of the names found in \code{gdb}. As of ComplexHeatmap
v2 (maybe earlier versions), this doesn't really work when
\code{cluster_rows = TRUE}.}

\item{name}{passed down to \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}}

\item{rm.collection.prefix}{When \code{TRUE} (default), removes the collection
name from the genesets annotated on the heatmap.}

\item{rm.dups}{if \code{aggregate.by == 'none'}, do we remove genes that
appear in more than one geneset? Defaults to \code{FALSE}}

\item{recenter}{do you want to mean center the rows of the heatmap matrix
prior to calling \code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}?}

\item{rescale}{do you want to standardize the row variance to one on the
values of the heatmap matrix prior to calling
\code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}?}

\item{center, scale}{boolean parameters passed down into the the single
sample gene set scoring methods defined by \code{aggregate.by}}

\item{rename.rows}{defaults to \code{NULL}, which induces no action. Specifying
a paramter here assumes you want to rename the rows of the heatmap.
Please refer to the "Renaming Rows" section for details.}

\item{zero_center_colramp}{Used to specify the type of color ramp to generate
when \code{col} is \code{NULL}. By default (\code{NULL}) we try to guess if we should
generate a 0-centered (blue, white, red) color ramp, or an absolute
(viridis style) one. The guessing functionality isn't that great, so
it doesn't hurt to explicitly set this to \code{TRUE} or \code{FALSE}.}

\item{zlim}{Used to control the color saturation of the heatmap when the
\code{col} parameter is not provided. If \code{NULL}, (default), extreme values
(outside the \code{c(0.025, 0.975)} quantiles) are axed and the colorRamp is
based on the remaining value range. If \code{FALSE}, the range of the colorRamp
is defined by the min/max values. Otherwise a length(2) numeric can be
supplied. If the values are between \verb{[0,1]}, then we assume this is a
quantile range to be calculated. Otherwise the number are assumed to
mark the top and bottom of the color scale range you want to use.}

\item{transpose}{Flip display so that rows are columns. Default is \code{FALSE}.}

\item{...}{parameters to send down to \code{\link[=scoreSingleSamples]{scoreSingleSamples()}},
\code{\link[ComplexHeatmap:Heatmap]{ComplexHeatmap::Heatmap()}}, \code{\link[=renameRows]{renameRows()}} internal \code{as_matrix()}.}
}
\value{
A \code{Heatmap} object.
}
\description{
Before we get started, note that you probably want to use \code{\link[=mgheatmap2]{mgheatmap2()}}.

This function encapsulates many common "moves" you'll make when trying to
make a heatmap, especially if you are trying to show geneset activity across
a panel of samples.

\strong{NOTE}: this function will \strong{almost certainly} reorder the rows of the
input matrix. If you are concatentating Heatmap objects together horizontally
(ie. you if you want to use a rowAnnotation along side the returned heatmap),
you must reorder the rows of the annotation data.frame, ie.
\code{ranno.df <- ranno.df[rownames(out@matrix),]}
}
\details{
More info here.
}
\section{Renaming Heatmap Rows}{

This function leverages \code{\link[=renameRows]{renameRows()}} so that you can better customize the
output of your heatmaps by tweaking its rownames.

If you are plotting a \strong{gene-level} heatmap (ie. \verb{aggregate.by == "none"``) and the }rownames()\verb{are gene identifiers, but you want the rownames of the heatmap to be gene symbols. You can perform this renaming using the}rename.rows` parameter.
\itemize{
\item If \code{rename.rows} is \code{NULL}, then nothing is done.
\item If \code{rename.rows} is a \code{string}, then we assume that \code{x} has an associated
metadata \code{data.frame} over its rows and that \code{rename.rows} names one of
its columns, ie. \code{DGEList$genes[[rename.rows]]} or
\code{fData(ExpressionSet)[[rename.rows]]}. The values in that column will
be swapped out for \code{x}'s rownames
\item If \code{rename.rows} is a two-column data.frame, the first column is assumed
to be \code{rownames(x)} and the second is what you want to rename it to.
\item When there are duplicates in the renamed rownames, the \code{rename.duplicates}
\code{...} parameter dictates the behavior. This will happen, for instance, if
you are trying to rename the rows of an affy matrix to gene symbols, where
we have multiple probe ids for one gene. When \code{rename.duplicates} is set to
\code{"original"}, one of the rows will get the new name, and the remaning
duplicate rows will keep the rownames they came in with. When set to
\code{"make.unique"}, the new names will contain \verb{*.1}, \verb{*.2}, etc. suffixes,
as you would get from using \code{\link[base:make.unique]{base::make.unique()}}.
}

Maybe you are aggregating the expression scores into geneset scores, and
you don't want the rownames of the heatmap to be \verb{collection;;name} (or just
\code{name} when \code{rm.collection.prefx = TRUE}), you can pass in a two column
\code{data.frame}, where the first column is \verb{collection;name} and the second
is the name you want to rename that to. There is an example of this in
the "Examples" section here.
}

\examples{
\donttest{
library(ComplexHeatmap)
vm <- exampleExpressionSet()
gdb <- exampleGeneSetDb()
col.anno <- ComplexHeatmap::HeatmapAnnotation(
  df = vm$targets[, c("Cancer_Status", "PAM50subtype")],
  col = list(
    Cancer_Status = c(normal = "grey", tumor = "red"),
    PAM50subtype = c(Basal = "purple", Her2 = "green", LumA = "orange")))
mgh <- mgheatmap(vm, gdb, aggregate.by = "ewm", split=TRUE,
                 top_annotation = col.anno, show_column_names = FALSE,
                 column_title = "Gene Set Activity in BRCA subset")

# Maybe you want the rownames of the matrix to use spaces instead of "_"
rr <- geneSets(gdb)[, "name", drop = FALSE]
rr$newname <- gsub("_", " ", rr$name)
mg2 <- mgheatmap(vm, gdb, aggregate.by='ewm', split=TRUE,
                 top_annotation = col.anno, show_column_names = FALSE,
                 column_title = "Gene Set Activity in BRCA subset",
                 rename.rows = rr)
}
}
\seealso{
\code{\link[=mgheatmap2]{mgheatmap2()}}
}
