% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/geneSetSummaryByGenes.R
\name{geneSetSummaryByGenes}
\alias{geneSetSummaryByGenes}
\alias{geneSetSummaryByGenes,GeneSetDb-method}
\alias{geneSetSummaryByGenes,SparrowResult-method}
\title{Summarize geneset:feature relationships for specified set of features}
\usage{
geneSetSummaryByGenes(
  x,
  features,
  with.features = TRUE,
  feature.rename = NULL,
  ...,
  as.dt = FALSE
)

\S4method{geneSetSummaryByGenes}{GeneSetDb}(
  x,
  features,
  with.features = TRUE,
  feature.rename = NULL,
  ...,
  as.dt = FALSE
)

\S4method{geneSetSummaryByGenes}{SparrowResult}(
  x,
  features,
  with.features = TRUE,
  feature.rename = NULL,
  method = NULL,
  max.p = 0.3,
  p.col = c("padj", "padj.by.collection", "pval"),
  ...,
  as.dt = FALSE
)
}
\arguments{
\item{x}{\code{GeneSetDb} or \code{SparrowResult}}

\item{features}{a character vector of featureIds}

\item{with.features}{Include columns for \code{features}? If \code{x} is
is a \code{GeneSetDb}, these columns are \code{TRUE}/\code{FALSE}. If
\code{x} is a \code{SparrowResult} object, the values are the logFC of
the feature if present in the gene set, otherwise its \code{NA}.}

\item{feature.rename}{if \code{NULL}, the feature columns are prefixed with
\code{featureId_}, if \code{FALSE}, no renaming is done. If \code{x} is
a \code{SparrowResult}, then this can be the column name found in
\code{logFC(x)}, in which case the value for the feature from the given
column name would be used (setting this to \code{"symbol"}) would be a
common thing to do, for instance.}

\item{...}{pass through arguments}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}

\item{method}{The GSEA method to pull statistics from}

\item{max.p}{the maximum p-value from the analysis \code{method} to allow for the
geneSets included in the returned table}

\item{p.col}{which p-value column to select from: \code{'padj'},
\code{'padj.by.collection'}, or \code{'pval'}}
}
\value{
a data.frame of geneset <-> feature incidence/feature matrix.
}
\description{
This function creates a geneset by feature table with geneset membership
information for the \code{features} specified by the user. Only the gene sets that
have any of the \code{features} are included in the table returned.
}
\section{Methods (by class)}{
\itemize{
\item \code{geneSetSummaryByGenes(SparrowResult)}: get geneset:feature incidence table from
a SparrowResult, optionally filtered by statistical significance from
a given gsea \code{method}

}}
\examples{
vm <- exampleExpressionSet(do.voom=TRUE)
gdb <- conform(exampleGeneSetDb(), vm)
mg <- seas(vm, gdb, design = vm$design, contrast = 'tumor')
features <- c("55839", "8522", "29087")
gsm.hit <- geneSetSummaryByGenes(gdb, features)
gsm.fid <- geneSetSummaryByGenes(mg, features, feature.rename=NULL)
gsm.sym <- geneSetSummaryByGenes(mg, features, feature.rename='symbol')
}
