% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_beads.R
\name{process_beads_batch}
\alias{process_beads_batch}
\title{Runs RCTD in doublet mode on \code{puck}}
\usage{
process_beads_batch(
  cell_type_info,
  gene_list,
  puck,
  class_df = NULL,
  constrain = TRUE,
  MAX_CORES = 8,
  MIN.CHANGE = 0.001,
  confidence_threshold = 10,
  doublet_threshold = 25
)
}
\arguments{
\item{cell_type_info}{cell type information and profiles of each cell,
calculated from the scRNA-seq reference (see
\code{\link{computeCellTypeInfo}})}

\item{gene_list}{a list of genes to be used for RCTD}

\item{puck}{an object of type \linkS4class{SpatialRNA}, the target dataset}

\item{class_df}{A dataframe mapping cell types to classes}

\item{constrain}{logical whether to constrain the weights to sum to one on
each pixel}

\item{MAX_CORES}{number of cores to use (will use parallel processing if more
than one).}

\item{MIN.CHANGE}{(default 0.001) the minimum change in the norm of the WLS
solution used to determine the cell type proportions}

\item{confidence_threshold}{(Default 10) the minimum change in likelihood
(compared to other cell types) necessary to determine a cell type identity
with confidence}

\item{doublet_threshold}{(Default 25) the penalty weight of predicting a
doublet instead of a singlet for a pixel}
}
\value{
Returns \code{results}, a list of RCTD results for each pixel, which
  can be organized by feeding into \code{\link{create_spe_doublet}}
}
\description{
Then, computes cell type proportions for each pixel in \code{puck}.
Classifies each pixel as 'singlet' or 'doublet' and searches for the cell
types on the pixel
}
\keyword{internal}
