% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/de_genes.R
\name{getDeGenes}
\alias{getDeGenes}
\title{Returns a list of differentially expressed genes}
\usage{
getDeGenes(
  spatial_counts,
  cell_type_info,
  fc_thresh = 1.25,
  expr_thresh = 0.00015,
  MIN_OBS = 3,
  de_type = "regression"
)
}
\arguments{
\item{spatial_counts}{spatial transcriptomics count matrix}

\item{cell_type_info}{cell type information and profiles of each cell,
calculated from the scRNA-seq reference (see
\code{\link{computeCellTypeInfo}})}

\item{fc_thresh}{minimum \code{log_e} fold change required for a gene.}

\item{expr_thresh}{minimum expression threshold, as normalized expression
(proportion out of 1, or counts per 1).}

\item{MIN_OBS}{the minimum number of occurances of each gene in the
SpatialRNA object.}

\item{de_type}{type of differential expression (i.e., "regression" or "bulk")}
}
\value{
a list of differentially expressed gene names
}
\description{
For each cell type, chooses genes that have a minimum average normalized
expression in that cell type, and whose expression is larger in that cell
type than the average of all cell types. Filters out mitochondrial genes.
}
\keyword{internal}
