% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_immune_rings.R
\name{simulate_immune_rings}
\alias{simulate_immune_rings}
\title{simulate_immune_rings}
\usage{
simulate_immune_rings(
  bg_sample = bg1,
  bg_type = "Others",
  n_ir = 2,
  ir_properties = list(I1 = list(name_of_cluster_cell = "Tumour", size = 600, shape =
    "Circle", centre_loc = data.frame(x = 930, y = 1000), infiltration_types =
    c("Immune1", "Immune2", "Others"), infiltration_proportions = c(0.15, 0.05, 0.05),
    name_of_ring_cell = "Immune1", immune_ring_width = 150,
    immune_ring_infiltration_types = c("Others"), immune_ring_infiltration_proportions =
    c(0.15)), I2 = list(name_of_cluster_cell = "Tumour", size = 500, shape = "Oval",
    centre_loc = data.frame(x = 1330, y = 1100), infiltration_types = c("Immune1", 
    
    "Immune2", "Others"), infiltration_proportions = c(0.15, 0.05, 0.05),
    name_of_ring_cell = "Immune1", immune_ring_width = 150,
    immune_ring_infiltration_types = c("Others"), immune_ring_infiltration_proportions =
    c(0.15))),
  plot_image = TRUE,
  plot_categories = NULL,
  plot_colours = NULL
)
}
\arguments{
\item{bg_sample}{(OPTIONAL) A data frame or \code{SpatialExperiment} class object
with locations of points representing background cells. Further cell types
will be simulated based on this background sample. The data.frame or the
\code{spatialCoords()} of the SPE object should have colnames including
"Cell.X.Positions" and "Cell.Y.Positions". By default use the internal
\code{\link{bg1}} background image.}

\item{bg_type}{(OPTIONAL) String The name of the background cell type. By
default is "Others".}

\item{n_ir}{Number of immune rings. This must match the arg
\code{length(ir_properties)}.}

\item{ir_properties}{List of properties of the immune rings. Please refer to
the examples for the structure of \code{ir_properties}.}

\item{plot_image}{Boolean. Whether the simulated image is plotted.}

\item{plot_categories}{String Vector specifying the order of the cell
categories to be plotted. Default is NULL - the cell categories under the
"Cell.Type" column would be used for plotting.}

\item{plot_colours}{String Vector specifying the order of the colours that
correspond to the \code{plot_categories} arg. Default is NULL - the predefined
colour vector would be used for plotting.}
}
\value{
A data.frame of the simulated image
}
\description{
Based on an existing background image, simulate rings of immune
cells that surround tumour clusters. The tumour clusters and immune rings
are simulated at the same time. The default values for the arguments give
an example of immune ring simulation which enable an automatic simulation
of immune rings without the specification of any argument.
}
\examples{
set.seed(610)
# manually define the properties of the immune ring
ir_properties <- list(I1=list(name_of_cluster_cell="Tumour", size=600,
shape="Circle",centre_loc=data.frame("x"=930, "y"=1000),
infiltration_types=c("Immune1", "Immune2", "Others"), infiltration_proportions
=c(0.15, 0.05, 0.05), name_of_ring_cell="Immune1", immune_ring_width=150,
immune_ring_infiltration_types=c("Others"), immune_ring_infiltration_proportions=c(0.15)),
I2=list(name_of_cluster_cell="Tumour", size=500, shape="Oval",
centre_loc=data.frame("x"=1330, "y"=1100), infiltration_types=c("Immune1", "Immune2", "Others"),
infiltration_proportions=c(0.15, 0.05, 0.05), name_of_ring_cell="Immune1",
immune_ring_width=150, immune_ring_infiltration_types=c("Others"),
immune_ring_infiltration_proportions=c(0.15)))
# simulate immune rings (`n_ir` should match the length of `ir_properties`)
immune_ring_image <- simulate_immune_rings(bg_sample=bg1,
n_ir=2, ir_properties=ir_properties)

}
\seealso{
\code{\link{simulate_background_cells}} for all cell simulation,
\code{\link{simulate_mixing}} for mixed background simulation,
\code{\link{simulate_clusters}} for cluster simulation,
\code{\link{simulate_double_rings}} for double immune ring simulation, and
\code{\link{simulate_stripes}} for vessel simulation.

Other simulate pattern functions: 
\code{\link{simulate_background_cells}()},
\code{\link{simulate_clusters}()},
\code{\link{simulate_double_rings}()},
\code{\link{simulate_mixing}()},
\code{\link{simulate_stripes}()}
}
\concept{simulate pattern functions}
