% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiple_background_images.R
\name{multiple_background_images}
\alias{multiple_background_images}
\title{Simulate multiple background images (mixed cell types)}
\usage{
multiple_background_images(
  bg_sample = bg1,
  idents = c("Tumour", "Immune", "Others"),
  props = list(rep(0.1, 9), seq(0, 0.4, 0.05), seq(0.9, 0.5, -0.05)),
  plot_image = TRUE,
  plot_colours = NULL
)
}
\arguments{
\item{bg_sample}{A data frame or \code{SpatialExperiment} class object with
locations of points representing background cells. Further cell types will
be simulated based on this background sample. The data.frame or the
\code{spatialCoords()} of the SPE object should have colnames including
"Cell.X.Positions" and "Cell.Y.Positions". By default use the internal
\code{\link{bg1}} background image.}

\item{idents}{String Vector. Names of the cell types to generate.}

\item{props}{List. Each element is a vector of proportions of the
corresponding cell type. The length of the vector is how many images to
generate. All vectors should be of the same length, also equal to the
number of images.}

\item{plot_image}{Boolean. Whether plot the simulated images or not. Default
is TRUE.}

\item{plot_colours}{String Vector. If plot_image is TRUE, this param is the
corresponding colours for the \code{idents} arg. Default is NULL, the predefined
colour vector would be used for plotting.}
}
\value{
A list of SPE objects
}
\description{
Generate a set of background images with different proportions
of mixed cell types all at once. The default values for the arguments give
an example of multiple image simulation which enable an automatic multiple
image simulation without the specification of any argument.
}
\examples{
idents <- c("Tumour","Immune","Others")
prop1 <- rep(0.1,9)
prop2 <- seq(0, 0.4, 0.05)
prop3 <- seq(0.9,0.5,-0.05)
set.seed(610)
bg_image_list <- multiple_background_images(bg_sample = bg1,
idents = idents, props = list(prop1, prop2, prop3), plot_image = FALSE)
}
\seealso{
\code{\link{multiple_images_with_clusters}} for simulating multiple
images with clusters, and \code{\link{multiple_images_with_immune_rings}}
for simulating multiple images with immune rings.

Other simulate multiple images functions: 
\code{\link{multiple_images_with_clusters}()},
\code{\link{multiple_images_with_immune_rings}()}
}
\concept{simulate multiple images functions}
