% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateData.R
\name{createPointPatternTissue}
\alias{createPointPatternTissue}
\title{Create a Point Pattern on a Simulated Tissue Image}
\usage{
createPointPatternTissue(tissueImage, intA, intB, intCInA, intCInB)
}
\arguments{
\item{tissueImage}{Matrix; A binary matrix representing the simulated tissue.}

\item{intA}{Numeric; Intensity of type "A" points (points per unit area) on tissue regions.}

\item{intB}{Numeric; Intensity of type "B" points (points per unit area) on non-tissue regions.}

\item{intCInA}{Numeric; Intensity of type "C" points placed in extended regions around tissue.}

\item{intCInB}{Numeric; Intensity of type "C" points placed within tissue.}
}
\value{
A \code{ppp} object representing the spatial point pattern.
}
\description{
This function generates a spatial point pattern with different types of points (\code{A}, \code{B}, \code{C}) distributed over the simulated tissue structure.
}
\examples{
tissueImage <- simulateTissueBlobs(128, 100, 7)
createPointPatternTissue(tissueImage, 0.1, 0.1, 0.005, 0.005)

}
