% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_builder_wrappers.R
\name{get_row_filters}
\alias{get_row_filters}
\alias{set_row_filters}
\title{Get or set range-related contraints for query}
\usage{
get_row_filters(qb)

set_row_filters(qb, ...)
}
\arguments{
\item{qb}{a QueryBuilder object constructed using the
\code{\link{QueryBuilder}} function.}

\item{...}{one or more boolean predicates as either strings or unevaluated
expressions.}
}
\value{
\code{get_row_filters} returns the current row filters as list of strings.
\code{set_row_filters} returns a new \code{QueryBuilder} object with
the row filters set to the value of \code{row_filters}.
}
\description{
Get or set range-related contraints for query
}
\examples{
qb <- QueryBuilder(compilation = "gtex", regions = "CD99")
# row filters set as a string
qb <- set_row_filters(qb, "strand == +")
get_row_filters(qb)
# row filters set using unevaluated expression
qb <- set_row_filters(qb, strand == "+")
get_row_filters(qb)
}
