% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query_builder_wrappers.R
\name{get_regions}
\alias{get_regions}
\alias{set_regions}
\title{Get or set query regions}
\usage{
get_regions(qb)

set_regions(qb, regions)
}
\arguments{
\item{qb}{A QueryBuilder object constructed using the
\code{\link{QueryBuilder}} function.}

\item{regions}{Either a list of 1 more \code{HUGO} gene names as strings
\verb{e.g. "BRCA1"} or a Granges class object containing one or more geneomic
intervals \verb{(e.g. "chr1:1-1000")}.}
}
\value{
\code{get_regions} returns the current regions as a list of strings.
\code{set_regions} returns a new \code{QueryBuilder} object with the
regions set to the value of \code{regions}.
}
\description{
Get or set query regions
}
\examples{
qb <- QueryBuilder(compilation = "gtex", regions = "CD99")
get_regions(qb)
qb <- set_regions(qb, "chr1:1-1000")
get_regions(qb)
qb <- set_regions(qb, GenomicRanges::GRanges("chr1", "1-1000"))
get_regions(qb)
}
