% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estGradients.R
\name{estGradients}
\alias{estGradients}
\alias{estGradientsSingle}
\alias{getPvaluesGradient}
\title{Estimate gradients over multiple point patterns, and test for significance}
\usage{
estGradients(
  hypFrame,
  gradients = c("overall", if (!is.null(hypFrame$owins)) "cell"),
  fixedEffects = NULL,
  randomEffects = NULL,
  verbose = FALSE,
  features = getFeatures(hypFrame),
  silent = TRUE,
  loopFun = "bplapply",
  ...
)

estGradientsSingle(
  hypFrame,
  gradients,
  fixedForm,
  randomForm,
  fixedFormSimple,
  effects = NULL,
  ...
)

getPvaluesGradient(res, gradient, method = "BH")
}
\arguments{
\item{hypFrame}{A hyperframe}

\item{gradients}{The gradients types to be estimated: "overall" or within cell ("cell")}

\item{fixedEffects, randomEffects}{Character vectors of fixed and random effects present in the hyperframe,
modifying the baseline intensity. See details.}

\item{verbose}{A boolean, whether to report on progress of the fitting process.}

\item{features}{A character vector, for which features should the
gradients indices be calculated?}

\item{silent}{A boolean, should error messages from spatstat.model::mppm be printed?}

\item{loopFun}{The function to use to loop over the features.}

\item{...}{Passed onto fitGradient}

\item{fixedForm, randomForm, fixedFormSimple}{Formulae for fixed effects,
random effects and fixed effects without slopes respectively}

\item{effects}{Character vector of fixed and random effects}

\item{res}{The fitted gradients}

\item{gradient}{The gradient to be extracted, a character vector equal to
"overall" or "cell".}

\item{method}{Method of multiplicity correction, see \link{p.adjust}.
Defaults to Benjamini-Hochberg.}
}
\value{
For estGradients(), a list with the estimated gradients

For estGradientsSingle(), a list containing
\item{overall}{Overall gradients}
\item{cell}{Gradients within the cell}

For getPvaluesGradient(), a vector of p-values
}
\description{
estGradients() estimate gradients on all single-molecule point patterns of a hyperframe. 
estGradientsSingle() is the workhorse function for a single point pattern.
getPvaluesGradient() extracts the p-values of the fits.
}
\details{
The test for existence of a gradient revolves around interaction terms
between x and y coordinates and image identifiers. If this interactions are
significant, this implies existence of gradients in the different point patterns,
albeit with different directions. Yet be aware that a gradient that is significant
for a computer may look very different from the human perspective; many
spatial patterns can be captured by a gradient to some extent.
Baseline intensity corrections for every image or cell are included by default.
The fixed and random effects modify the baseline intensity of the point pattern, not the gradient!
Random effects can lead to problems with fitting and are dissuaded.
}
\note{
Fitting Poisson point processes is computation-intensive.
}
\examples{
# Overall Gradients
data(Yang)
hypYang <- buildHyperFrame(Yang,
    coordVars = c("x", "y"),
    imageVars = c("day", "root", "section")
)
yangGrads <- estGradients(hypYang[seq_len(2), ],
    features = getFeatures(hypYang)[1],
    fixedEffects = "day", randomEffects = "root")
# Gradients within cell
data(Eng)
hypEng <- buildHyperFrame(Eng[Eng$fov \%in\% c(1,2),], 
    coordVars = c("x", "y"),
    imageVars = c("fov", "experiment")
) #Subset for speed
hypEng <- addCell(hypEng, EngRois[rownames(hypEng)], verbose = FALSE)
# Limit number of cells and genes for computational reasons
engGrads <- estGradients(hypEng[seq_len(2),],
    features = feat <- getFeatures(hypEng)[1])
pVals <- getPvaluesGradient(engGrads, "cell")
}
\seealso{
\link{fitGradient}
}
