% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcNNPI.R
\name{calcNNPI}
\alias{calcNNPI}
\title{Estimate the PI for nearest neighbour distances with the negative hypergeometric distribution}
\usage{
calcNNPI(Ranks, n, m, ties, r = 1)
}
\arguments{
\item{Ranks}{The (approximate) ranks, number of times observed distance is larger}

\item{n}{the total number of observed distances minus the number of distances
under consideration (the number of failures or black balls in the urn)}

\item{m}{the number of observed distances (successes or white balls in the urn)}

\item{ties}{The number of times the observed distance is equal to a null distance,
of the same length as Ranks}

\item{r}{The rank of distances considered, r=1 is nearest neighbour distance}
}
\value{
A vector of evaluations of the negative hypergeometric distribution
function
}
\description{
Estimate the PI for the nearest neighbour distances, given a set of ranks,
using the negative hypergeometric distribution
}
\details{
Ties are counted half to match the definition of the PI.
}
\seealso{
\link[extraDistr]{pnhyper}, \link{calcIndividualPIs}
}
