% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{runSeuratTSNE}
\alias{runSeuratTSNE}
\title{runSeuratTSNE
Computes tSNE from the given sce object and stores the tSNE computations back
into the sce object}
\usage{
runSeuratTSNE(
  inSCE,
  useReduction = c("pca", "ica"),
  reducedDimName = "seuratTSNE",
  dims = 10,
  perplexity = 30,
  externalReduction = NULL,
  seed = 1
)
}
\arguments{
\item{inSCE}{(sce) object on which to compute the tSNE}

\item{useReduction}{selected reduction algorithm to use for computing tSNE.
One of "pca" or "ica". Default \code{"pca"}.}

\item{reducedDimName}{Name of new reducedDims object containing Seurat tSNE
Default \code{seuratTSNE}.}

\item{dims}{Number of reduction components to use for tSNE computation.
Default \code{10}.}

\item{perplexity}{Adjust the perplexity tuneable parameter for the underlying
tSNE call. Default \code{30}.}

\item{externalReduction}{Pass DimReduc object if PCA/ICA computed through
other libraries. Default \code{NULL}.}

\item{seed}{Random seed for reproducibility of results.
Default \code{1}.}
}
\value{
Updated sce object with tSNE computations stored
}
\description{
runSeuratTSNE
Computes tSNE from the given sce object and stores the tSNE computations back
into the sce object
}
