% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{runScanpyNormalizeData}
\alias{runScanpyNormalizeData}
\title{runScanpyNormalizeData
Wrapper for NormalizeData() function from scanpy library
Normalizes the sce object according to the input parameters}
\usage{
runScanpyNormalizeData(
  inSCE,
  useAssay,
  targetSum = 10000,
  maxFraction = 0.05,
  normAssayName = "scanpyNormData"
)
}
\arguments{
\item{inSCE}{(sce) object to normalize}

\item{useAssay}{Assay containing raw counts to use for normalization.}

\item{targetSum}{If NULL, after normalization, each observation (cell) has a 
total count equal to the median of total counts for observations (cells) 
before normalization. Default \code{1e4}}

\item{maxFraction}{Include cells that have more counts than max_fraction of 
the original total counts in at least one cell. Default \code{0.05}}

\item{normAssayName}{Name of new assay containing normalized data. Default
\code{scanpyNormData}.}
}
\value{
Normalized \code{SingleCellExperiment} object
}
\description{
runScanpyNormalizeData
Wrapper for NormalizeData() function from scanpy library
Normalizes the sce object according to the input parameters
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
rownames(sce) <- rowData(sce)$feature_name
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
}
}
