% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichRSCE.R
\name{runEnrichR}
\alias{runEnrichR}
\title{Run EnrichR on SCE object}
\usage{
runEnrichR(
  inSCE,
  features,
  analysisName,
  db = NULL,
  by = "rownames",
  featureName = NULL
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object.}

\item{features}{Character vector, selected genes for enrichment analysis.}

\item{analysisName}{A string that identifies each specific analysis.}

\item{db}{Character vector. Selected database name(s) from the enrichR
database list. If \code{NULL} then EnrichR will be run on all the available
databases on the enrichR database. See details. Default \code{NULL}}

\item{by}{Character. From where should we find the \code{features}?
\code{"rownames"} for from \code{rownames(inSCE)}, otherwise, from a column
of feature metadata (\code{rowData(inSCE)[[by]]}). See details. Default
\code{"rownames"}.}

\item{featureName}{Character. Indicates the actual feature identifiers to be
passed to EnrichR. Can be \code{"rownames"}, a column in feature metadata
(\code{rowData(inSCE)[[featureName]]}), or a character vector with its length
equals to \code{nrow(inSCE)}. See details. Default \code{"rownames"}.}
}
\value{
Updates \code{inSCE} metadata with a data.frame of enrichment terms
overlapping in the respective databases along with p-values, z-scores etc.
}
\description{
Run EnrichR on SCE object
}
\details{
EnrichR works by querying the specified \code{features} to its online
databases, thus it requires the Internet connection.

Available \code{db} options could be shown by running
\code{enrichR::listEnrichrDbs()$libraryName}

This function checks for the existence of features in the SCE object. When
\code{features} do not have a match in \code{rownames(inSCE)}, users may
try to specify \code{by} to pass the check.

EnrichR expects gene symbols/names as the input (i.e. Ensembl ID might not
work). When specified \code{features} are not qualified for this, users may
try to specify \code{featureName} to change the identifier type to pass to
EnrichR.
}
\examples{
data("mouseBrainSubsetSCE")
if (Biobase::testBioCConnection()) {
  mouseBrainSubsetSCE <- runEnrichR(mouseBrainSubsetSCE, features =  c("Vamp7","Cntn2","Olig1"),
                                    db = "GO_Cellular_Component_2025",
                                    analysisName = "analysis1")
}

}
\seealso{
\code{\link{getEnrichRResult}}
}
