% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runBatchCorrection.R
\name{runBBKNN}
\alias{runBBKNN}
\title{Apply BBKNN batch effect correction method to SingleCellExperiment object}
\usage{
runBBKNN(
  inSCE,
  useAssay = "logcounts",
  batch = "batch",
  reducedDimName = "BBKNN",
  nComponents = 50L
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object}

\item{useAssay}{A single character indicating the name of the assay requiring
batch correction. Default \code{"logcounts"}.}

\item{batch}{A single character indicating a field in \code{colData} that
annotates the batches of each cell; or a vector/factor with the same length
as the number of cells. Default \code{"batch"}.}

\item{reducedDimName}{A single character. The name for the corrected
low-dimensional representation. Will be saved to \code{reducedDim(inSCE)}.
Default \code{"BBKNN"}.}

\item{nComponents}{An integer. Number of principle components or the
dimensionality, adopted in the pre-PCA-computation step, the BBKNN step (for
how many PCs the algorithm takes into account), and the final UMAP
combination step where the value represent the dimensionality of the updated
reducedDim. Default \code{50L}.}
}
\value{
The input \linkS4class{SingleCellExperiment} object with
\code{reducedDim(inSCE, reducedDimName)} updated.
}
\description{
BBKNN, an extremely fast graph-based data integration algorithm. It modifies
the neighbourhood construction step to produce a graph that is balanced
across all batches of the data.
}
\examples{
\dontrun{
data('sceBatches', package = 'singleCellTK')
logcounts(sceBatches) <- log1p(counts(sceBatches))
sceBatches <- runBBKNN(sceBatches, useAssay = "logcounts",
                       nComponents = 10)
}
}
\references{
Krzysztof Polanski et al., 2020
}
