% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTSNE.R
\name{plotTSNE}
\alias{plotTSNE}
\title{Plot t-SNE plot on dimensionality reduction data run from t-SNE method.}
\usage{
plotTSNE(
  inSCE,
  colorBy = NULL,
  shape = NULL,
  reducedDimName = "TSNE",
  runTSNE = FALSE,
  useAssay = "counts"
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{colorBy}{color by condition.}

\item{shape}{add shape to each distinct label.}

\item{reducedDimName}{a name to store the results of the dimension reduction
coordinates obtained from this method. This is stored in the SingleCellExperiment
object in the reducedDims slot. Required.}

\item{runTSNE}{Run t-SNE if the reducedDimName does not exist. the Default is
FALSE.}

\item{useAssay}{Indicate which assay to use. The default is "logcounts".}
}
\value{
A t-SNE plot
}
\description{
Plot t-SNE plot on dimensionality reduction data run from t-SNE method.
}
\examples{
data("mouseBrainSubsetSCE")
plotTSNE(mouseBrainSubsetSCE, colorBy = "level1class",
         reducedDimName = "TSNE_counts")
}
