% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTSCAN.R
\name{plotTSCANResults}
\alias{plotTSCANResults}
\title{Plot MST pseudotime values on cell 2D embedding}
\usage{
plotTSCANResults(inSCE, useReducedDim = "UMAP")
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{useReducedDim}{Saved dimension reduction name in \code{inSCE} object.
Required.}
}
\value{
A \code{.ggplot} object with the pseudotime ordering of the cells
colored on a cell 2D embedding, and the MST path drawn on it.
}
\description{
A wrapper function which visualizes outputs from the
\code{\link{runTSCAN}} function. Plots the pseudotime ordering of the cells
and project them onto the MST.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runTSCAN(inSCE = mouseBrainSubsetSCE,
                                useReducedDim = "PCA_logcounts")
plotTSCANResults(inSCE = mouseBrainSubsetSCE,
                 useReducedDim = "TSNE_logcounts")
}
\author{
Nida Pervaiz
}
