% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSoupX.R
\name{plotSoupXResults}
\alias{plotSoupXResults}
\title{Plot SoupX Result}
\usage{
plotSoupXResults(
  inSCE,
  sample = NULL,
  background = FALSE,
  reducedDimName = NULL,
  plotNCols = 3,
  plotNRows = 2,
  baseSize = 8,
  combinePlot = c("all", "sample", "none"),
  xlab = NULL,
  ylab = NULL,
  dim1 = NULL,
  dim2 = NULL,
  labelClusters = FALSE,
  clusterLabelSize = 3.5,
  defaultTheme = TRUE,
  dotSize = 0.5,
  transparency = 1,
  titleSize = NULL,
  axisLabelSize = NULL,
  axisSize = NULL,
  legendSize = NULL,
  legendTitleSize = NULL
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object. With
\code{\link{runSoupX}} already applied.}

\item{sample}{Character vector. Indicates which sample each cell belongs to.
Default \code{NULL}.}

\item{background}{Logical. Whether \code{background} was applied when
running \code{\link{runSoupX}}. Default \code{FALSE}.}

\item{reducedDimName}{Character. The embedding to use for plotting. Leave it
\code{NULL} for using the sample-specific UMAPs generated when running
\code{\link{runSoupX}}. Default \code{NULL}.}

\item{plotNCols}{Integer. Number of columns for the plot grid per sample.
Will determine the number of top markers to show together with
\code{plotNRows}. Default \code{3}.}

\item{plotNRows}{Integer. Number of rows for the plot grid per sample. Will
determine the number of top markers to show together with \code{plotNCols}.
Default \code{2}.}

\item{baseSize}{Numeric. The base font size for all text. Default 12. Can be
overwritten by titleSize, axisSize, and axisLabelSize, legendSize,
legendTitleSize. Default \code{8}.}

\item{combinePlot}{Must be either \code{"all"}, \code{"sample"}, or
\code{"none"}. \code{"all"} will combine all plots into a single
\code{.ggplot} object, while \code{"sample"} will output a list of plots
separated by sample. Default \code{"all"}.}

\item{xlab}{Character vector. Label for x-axis. Default \code{NULL}.}

\item{ylab}{Character vector. Label for y-axis. Default \code{NULL}.}

\item{dim1}{See \code{\link{plotSCEDimReduceColData}}. Default \code{NULL}.}

\item{dim2}{See \code{\link{plotSCEDimReduceColData}}. Default \code{NULL}.}

\item{labelClusters}{Logical. Whether the cluster labels are plotted. Default
\code{FALSE}.}

\item{clusterLabelSize}{Numeric. Determines the size of cluster label when
\code{labelClusters} is set to \code{TRUE}. Default \code{3.5}.}

\item{defaultTheme}{Logical. Adds grid to plot when \code{TRUE}. Default
\code{TRUE}.}

\item{dotSize}{Numeric. Size of dots. Default \code{0.5}.}

\item{transparency}{Numeric. Transparency of the dots, values will be from 0
to 1. Default \code{1}.}

\item{titleSize}{Numeric. Size of title of plot. Default \code{15}.}

\item{axisLabelSize}{Numeric. Size of x/y-axis labels. Default \code{NULL}.}

\item{axisSize}{Numeric. Size of x/y-axis ticks. Default \code{NULL}.}

\item{legendSize}{Numeric. Size of legend. Default \code{NULL}.}

\item{legendTitleSize}{Numeric. Size of legend title. Default \code{NULL}.}
}
\value{
ggplot object of the combination of UMAPs. See description.
}
\description{
This function will generate a combination of plots basing on the
correction done by SoupX. For each sample, there will be a UMAP with cluster
labeling, followed by a number of UMAPs showing the change in selected top
markers. The cluster labeling is what should be used for SoupX to estimate
the contamination. The Soup Fraction is calculated by subtracting the gene
expression value of the output corrected matrix from that of the original
input matrix, and then devided by the input.
}
\examples{
\dontrun{
sce <- importExampleData("pbmc3k")
sce <- runSoupX(sce, sample = "sample")
plotSoupXResults(sce, sample = "sample")
}
}
\seealso{
runSoupX
}
