% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyMarkerGenesMatrixPlot}
\alias{plotScanpyMarkerGenesMatrixPlot}
\title{plotScanpyMarkerGenesMatrixPlot}
\usage{
plotScanpyMarkerGenesMatrixPlot(
  inSCE,
  groups = NULL,
  nGenes = 10,
  groupBy,
  log2fcThreshold = NULL,
  parameters = "logfoldchanges",
  standardScale = "var",
  features = NULL,
  title = "",
  vmin = NULL,
  vmax = NULL,
  colorBarTitle = "log fold change"
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{groups}{The groups for which to show the gene ranking. Default \code{NULL}
means that all groups will be considered.}

\item{nGenes}{Number of genes to show. Default \code{10}}

\item{groupBy}{The key of the observation grouping to consider. By default, 
the groupby is chosen from the rank genes groups parameter.}

\item{log2fcThreshold}{Only output DEGs with the absolute values of log2FC
larger than this value. Default \code{NULL}.}

\item{parameters}{The options for marker genes results to plot are: 
‘scores’, ‘logfoldchanges’, ‘pvals’, ‘pvals_adj’, ‘log10_pvals’, ‘log10_pvals_adj’.
If NULL provided then it uses mean gene value to plot.}

\item{standardScale}{Whether or not to standardize the given dimension 
between 0 and 1, meaning for each variable or group, subtract the minimum and 
divide each by its maximum. Default \code{NULL} means that it doesn't perform
any scaling.}

\item{features}{Genes to plot. Sometimes is useful to pass a specific list of
var names (e.g. genes) to check their fold changes or p-values, instead of 
the top/bottom genes. The var_names could be a dictionary or a list. 
Default \code{NULL}}

\item{title}{Provide title for the figure.}

\item{vmin}{The value representing the lower limit of the color scale. 
Values smaller than vmin are plotted with the same color as vmin. 
Default \code{NULL}}

\item{vmax}{The value representing the upper limit of the color scale. 
Values larger than vmax are plotted with the same color as vmax. 
Default \code{NULL}}

\item{colorBarTitle}{Title for the color bar.}
}
\value{
plot object
}
\description{
plotScanpyMarkerGenesMatrixPlot
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyFindMarkers(sce, colDataName = "Scanpy_louvain_1" )
plotScanpyMarkerGenesMatrixPlot(sce, groupBy = 'Scanpy_louvain_1')
}
}
