% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichRSCE.R
\name{plotEnrichR}
\alias{plotEnrichR}
\title{Plot EnrichR results}
\usage{
plotEnrichR(
  inSCE,
  analysisName,
  showTerms = 20,
  numChar = 40,
  y = "Count",
  orderBy = "Adjusted.P.value",
  xlab = NULL,
  ylab = NULL,
  title = NULL
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
EnrichR results. Required.}

\item{analysisName}{A string that identifies the specific analysis to plot.
Required.}

\item{showTerms}{Number of enrichment terms to show. Default is 20.}

\item{numChar}{Integer. Indicates the maximum number characters to be
displayed in the term names. Default is 40.}

\item{y}{Character string. Indicates the variable to be shown on the
y-axis. Can be one of "Count" or "Ratio". Results that include background
genes can only show "Count". Default is "Count".}

\item{orderBy}{Charachter string. Indicates how to order the results prior
to subsetting. Can be one of "P.value", "Adjusted.P.Value",
or "Combined.Score". Default is "Adjusted.P.value".}

\item{xlab}{Character vector. Label for x-axis. Default NULL.}

\item{ylab}{Character vector. Label for y-axis. Default NULL.}

\item{title}{Character string. Title of the plot. Default NULL.}
}
\value{
A ggplot object of EnrichR results.
}
\description{
Plot results of EnrichR analysis as a barplot.
}
