% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBubble.R
\name{plotBubble}
\alias{plotBubble}
\title{Plot Bubble plot}
\usage{
plotBubble(
  inSCE,
  useAssay = "logcounts",
  featureNames,
  displayName = NULL,
  groupNames = "cluster",
  title = "",
  xlab = NULL,
  ylab = NULL,
  colorLow = "white",
  colorHigh = "blue",
  scale = FALSE
)
}
\arguments{
\item{inSCE}{The single cell experiment to use.}

\item{useAssay}{The assay to use.}

\item{featureNames}{A string or vector of strings with each gene to aggregate.}

\item{displayName}{A string that is the name of the column used for genes.}

\item{groupNames}{The name of a colData entry that can be used as groupNames.}

\item{title}{The title of the bubble plot}

\item{xlab}{The x-axis label}

\item{ylab}{The y-axis label}

\item{colorLow}{The color to be used for lowest value of mean expression}

\item{colorHigh}{The color to be used for highest value of mean expression}

\item{scale}{Option to scale the data. Default: \code{FALSE}. Selected assay will not be scaled.}
}
\value{
A ggplot of the bubble plot.
}
\description{
Plot a bubble plot with the color of the plot being the mean expression
and the size of the dot being the percent of cells in the cluster expressing the gene.
}
\examples{
data("scExample")
plotBubble(inSCE=sce, useAssay="counts", featureNames=c("B2M", "MALAT1"),
displayName="feature_name", groupNames="type", title="cell type test",
xlab="gene", ylab="cluster", colorLow="white", colorHigh="blue")
}
