% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeSCEColData.R
\name{mergeSCEColData}
\alias{mergeSCEColData}
\title{Merging colData from two singleCellExperiment objects}
\usage{
mergeSCEColData(inSCE1, inSCE2, id1 = "column_name", id2 = "column_name")
}
\arguments{
\item{inSCE1}{Input SingleCellExperiment object. The function will output this
singleCellExperiment object with a combined colData from inSCE1 and inSCE2.}

\item{inSCE2}{Input SingleCellExperiment object. colData from this object
will be merged with colData from inSCE1 and loaded into inSCE1.}

\item{id1}{Character vector. Column in colData of inSCE1 that will be
used to combine inSCE1 and inSCE2. Default "column_name"}

\item{id2}{Character vector. Column in colData of inSCE2 that will be
used to combine inSCE1 and inSCE2. Default "column_name"}
}
\value{
SingleCellExperiment object containing combined colData from
 both singleCellExperiment for samples in inSCE1.
}
\description{
Merges colData of the singleCellExperiment objects
 obtained from the same dataset which contain differing colData.
 (i.e. raw data and filtered data)
}
\examples{
sce1 <- importCellRanger(
    cellRangerDirs = system.file("extdata/", package = "singleCellTK"),
    sampleDirs = "hgmm_1k_v3_20x20",
    sampleNames = "hgmm1kv3",
    dataType = "filtered")
data(scExample)
sce2 <- sce
sce <- mergeSCEColData(inSCE1 = sce1, inSCE2 = sce2, id1 = "column_name", id2 = "column_name")
}
