% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeHeatmap.R
\name{computeHeatmap}
\alias{computeHeatmap}
\title{Computes heatmap for a set of features against dimensionality reduction 
components}
\usage{
computeHeatmap(
  inSCE,
  useAssay,
  dims = 10,
  nfeatures = 30,
  cells = NULL,
  reduction = "pca",
  disp.min = -2.5,
  disp.max = 2.5,
  balanced = TRUE,
  nCol = NULL,
  externalReduction = NULL
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{useAssay}{Specify the name of the assay that will be scaled
by this function for the features that are used in the heatmap.}

\item{dims}{Specify the number of dimensions to use for heatmap. Default
\code{10}.}

\item{nfeatures}{Specify the number of features to use for heatmap. Default
is \code{30}.}

\item{cells}{Specify the samples/cells to use for heatmap computation.
Default is \code{NULL} which will utilize all samples in the assay.}

\item{reduction}{Specify the reduction slot in the input object. Default
is \code{"pca"}.}

\item{disp.min}{Specify the minimum dispersion value to use for floor
clipping of assay values. Default is \code{-2.5}.}

\item{disp.max}{Specify the maximum dispersion value to use for ceiling
clipping of assay values. Default is \code{2.5}.}

\item{balanced}{Specify if the number of of up-regulated and down-regulated
features should be balanced. Default is \code{TRUE}.}

\item{nCol}{Specify the number of columns in the output plot. Default
is \code{NULL} which will auto-compute the number of columns.}

\item{externalReduction}{Specify an external reduction if not present in
the input object. This external reduction should be created
using \code{CreateDimReducObject} function.}
}
\value{
Heatmap plot object.
}
\description{
The computeHeatmap method computes the heatmap visualization for a set
 of features against a set of dimensionality reduction components. This
 method uses the heatmap computation algorithm code from \code{Seurat} but
 plots the heatmap using \code{ComplexHeatmap} and \code{cowplot} libraries.
}
