% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combineSCE.R
\name{combineSCE}
\alias{combineSCE}
\title{Combine a list of SingleCellExperiment objects as one SingleCellExperiment object}
\usage{
combineSCE(sceList, by.r = NULL, by.c = NULL, combined = TRUE)
}
\arguments{
\item{sceList}{A list contains \link[SingleCellExperiment]{SingleCellExperiment} objects.
Currently, combineSCE function only support combining SCE objects with assay in dgCMatrix format.
It does not support combining SCE with assay in delayedArray format.}

\item{by.r}{Specifications of the columns used for merging rowData. If set as NULL, 
the rownames of rowData tables will be used to merging rowData. Default is NULL.}

\item{by.c}{Specifications of the columns used for merging colData. If set as NULL, 
the rownames of colData tables will be used to merging colData. Default is NULL.}

\item{combined}{logical; if TRUE, it will combine the list of SingleCellExperiment objects 
and return a SingleCellExperiment. If FALSE, it will return a list of SingleCellExperiment whose
rowData, colData, assay and reducedDim data slot are compatible within SCE objects in the list. 
Default is TRUE.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object which combines all
objects in sceList. The colData is merged.
}
\description{
Combine a list of SingleCellExperiment objects as one SingleCellExperiment object
}
\examples{
data(scExample, package = "singleCellTK")
combinedsce <- combineSCE(list(sce,sce), by.r = NULL, by.c = NULL, combined = TRUE)
}
