% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subsetSCE.R
\name{subsetSCERows}
\alias{subsetSCERows}
\title{Subset a SingleCellExperiment object by rows}
\usage{
subsetSCERows(
  inSCE,
  index = NULL,
  bool = NULL,
  rowData = NULL,
  returnAsAltExp = TRUE,
  altExpName = "subset",
  prependAltExpName = TRUE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{index}{Integer vector. Vector of indicies indicating which rows
to keep. If \code{NULL}, this will not be used for subsetting.
Default \code{NULL}.}

\item{bool}{Boolean vector. Vector of \code{TRUE} or \code{FALSE}
indicating which rows should be kept. Needs to be the same length as the
number of rows in \code{inSCE}. If \code{NULL}, this will not be used
for subsetting. Default \code{NULL}.}

\item{rowData}{Character. An expression that will identify a subset of rows
using variables found in the \code{rowData} of \code{inSCE}. For example,
if \code{x} is a numeric vector in \code{rowData}, then \code{"x < 5"} will
return all rows with x less than 5. Single quotes should be used for
character strings. For example, \code{"y == 'yes'"} will return all
rows where y is "yes". Multiple expressions can be evaluated by placing them
in a vector. For example \code{c("x < 5", "y =='yes'")} will apply both
operations for subsetting. If \code{NULL}, this will not be used for
subsetting. Default \code{NULL}.}

\item{returnAsAltExp}{Boolean. If \code{TRUE}, the subsetted
\linkS4class{SingleCellExperiment} object will be returned in the
\code{altExp} slot of \code{inSCE}. If \code{FALSE}, the subsetted
\linkS4class{SingleCellExperiment} object will be directly returned.}

\item{altExpName}{Character. Name of the alternative experiment object to
add if \code{returnAsAltExp = TRUE}. Default \code{subset}.}

\item{prependAltExpName}{Boolean. If \code{TRUE}, \code{altExpName} will
be added to the beginning of the assay names in the \code{altExp} object.
This is only utilized if \code{returnAsAltExp = TRUE}. Default \code{TRUE}.}
}
\value{
A \link[SingleCellExperiment]{SingleCellExperiment} object that has
been subsetted by rowData.
}
\description{
Used to peform subsetting of a
\linkS4class{SingleCellExperiment} object using a variety of methods that
indicate the correct rows to keep. The various methods,
\code{index}, \code{bool}, and \code{rowData}, can be used in conjunction
with one another. If \code{returnAsAltExp} is set to \code{TRUE},
then the returned object will have the same number of rows as the input
\code{inSCE} as the subsetted object will be stored in the
\code{\link{altExp}} slot.
}
\examples{
data(scExample)

# Set a variable up in the rowData indicating mitochondrial genes
rowData(sce)$isMito <- ifelse(grepl("^MT-", rowData(sce)$feature_name),
                              "yes", "no")
sce <- subsetSCERows(sce, rowData = "isMito == 'yes'")
}
\author{
Joshua D. Campbell
}
