% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runTSCAN.R
\name{runTSCANClusterDEAnalysis}
\alias{runTSCANClusterDEAnalysis}
\title{Find DE genes between all TSCAN paths rooted from given cluster}
\usage{
runTSCANClusterDEAnalysis(
  inSCE,
  useCluster,
  useAssay = "logcounts",
  fdrThreshold = 0.05
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object.}

\item{useCluster}{The cluster to be regarded as the root, has to existing in
\code{colData(inSCE)$TSCAN_clusters}.}

\item{useAssay}{Character. The name of the assay to use. This assay should
contain log normalized counts. Default \code{"logcounts"}.}

\item{fdrThreshold}{Only out put DEGs with FDR value smaller than this value.
Default \code{0.05}.}
}
\value{
The input \code{inSCE} with results updated in \code{metadata}.
}
\description{
This function finds all paths that root from a given cluster
\code{useCluster}, and performs tests to identify significant features for
each path, and are not significant and/or changing in the opposite direction
in the other paths. Using a branching cluster (i.e. a node with degree > 2)
may highlight features which are responsible for the branching event. MST has
to be pre-calculated with \code{\link{runTSCAN}}.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runTSCAN(inSCE = mouseBrainSubsetSCE,
                                useReducedDim = "PCA_logcounts")
mouseBrainSubsetSCE <- runTSCANClusterDEAnalysis(inSCE = mouseBrainSubsetSCE,
                                         useCluster = 1)
}
\author{
Nida Pervaiz
}
