% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{runSeuratNormalizeData}
\alias{runSeuratNormalizeData}
\title{runSeuratNormalizeData
Wrapper for NormalizeData() function from seurat library
Normalizes the sce object according to the input parameters}
\usage{
runSeuratNormalizeData(
  inSCE,
  useAssay,
  normAssayName = "seuratNormData",
  normalizationMethod = "LogNormalize",
  scaleFactor = 10000,
  verbose = TRUE
)
}
\arguments{
\item{inSCE}{(sce) object to normalize}

\item{useAssay}{Assay containing raw counts to use for normalization.}

\item{normAssayName}{Name of new assay containing normalized data. Default
\code{seuratNormData}.}

\item{normalizationMethod}{selected normalization method. Default
\code{"LogNormalize"}.}

\item{scaleFactor}{numeric value that represents the scaling factor. Default
\code{10000}.}

\item{verbose}{Logical value indicating if informative messages should
be displayed. Default is \code{TRUE}.}
}
\value{
Normalized \code{SingleCellExperiment} object
}
\description{
runSeuratNormalizeData
Wrapper for NormalizeData() function from seurat library
Normalizes the sce object according to the input parameters
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runSeuratNormalizeData(sce, useAssay = "counts")
}
}
