% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scanpyFunctions.R
\name{plotScanpyEmbedding}
\alias{plotScanpyEmbedding}
\title{plotScanpyEmbedding}
\usage{
plotScanpyEmbedding(
  inSCE,
  reducedDimName,
  useAssay = NULL,
  color = NULL,
  legend = "right margin",
  title = ""
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object.}

\item{reducedDimName}{Name of reducedDims object containing embeddings.
Eg. scanpyUMAP.}

\item{useAssay}{Specify name of assay to use. Default is \code{NULL},
which will use scaled assay by default.}

\item{color}{Keys for annotations of observations/cells or variables/genes.}

\item{legend}{Location of legend, either 'on data', 'right margin' or a 
valid keyword for the loc parameter of Legend.}

\item{title}{Provide title for panels either as string or list of strings}
}
\value{
plot object
}
\description{
plotScanpyEmbedding
}
\examples{
data(scExample, package = "singleCellTK")
\dontrun{
sce <- runScanpyNormalizeData(sce, useAssay = "counts")
sce <- runScanpyFindHVG(sce, useAssay = "scanpyNormData", method = "seurat")
sce <- runScanpyScaleData(sce, useAssay = "scanpyNormData")
sce <- runScanpyPCA(sce, useAssay = "scanpyScaledData")
sce <- runScanpyFindClusters(sce, useReducedDim = "scanpyPCA")
sce <- runScanpyUMAP(sce, useReducedDim = "scanpyPCA")
plotScanpyEmbedding(sce, reducedDimName = "scanpyUMAP", color = 'Scanpy_louvain_1')
}
}
