% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPerQCWrapper.R
\name{plotCxdsResults}
\alias{plotCxdsResults}
\title{Plots for runCxds outputs.}
\usage{
plotCxdsResults(
  inSCE,
  sample = NULL,
  shape = NULL,
  groupBy = NULL,
  combinePlot = "all",
  violin = TRUE,
  boxplot = FALSE,
  dots = TRUE,
  reducedDimName = "UMAP",
  xlab = NULL,
  ylab = NULL,
  dim1 = NULL,
  dim2 = NULL,
  bin = NULL,
  binLabel = NULL,
  defaultTheme = TRUE,
  dotSize = 0.5,
  summary = "median",
  summaryTextSize = 3,
  transparency = 1,
  baseSize = 15,
  titleSize = NULL,
  axisLabelSize = NULL,
  axisSize = NULL,
  legendSize = NULL,
  legendTitleSize = NULL,
  relHeights = 1,
  relWidths = c(1, 1, 1),
  plotNCols = NULL,
  plotNRows = NULL,
  labelSamples = TRUE,
  samplePerColumn = TRUE,
  sampleRelHeights = 1,
  sampleRelWidths = 1
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
dimension reduction components or a variable with saved results from
\code{\link{runCxds}}. Required.}

\item{sample}{Character vector or colData variable name. Indicates which
sample each cell belongs to. Default \code{NULL}.}

\item{shape}{If provided, add shapes based on the value. Default \code{NULL}.}

\item{groupBy}{Groupings for each numeric value. A user may input a vector
equal length to the number of the samples in \code{inSCE}, or can be
retrieved from the colData slot. Default \code{NULL}.}

\item{combinePlot}{Must be either \code{"all"}, \code{"sample"}, or
\code{"none"}. \code{"all"} will combine all plots into a single .ggplot
object, while \code{"sample"} will output a list of plots separated by
sample. Default \code{"all"}.}

\item{violin}{Boolean. If \code{TRUE}, will plot the violin plot. Default
\code{TRUE}.}

\item{boxplot}{Boolean. If \code{TRUE}, will plot boxplots for each violin
plot. Default \code{TRUE}.}

\item{dots}{Boolean. If \code{TRUE}, will plot dots for each violin plot.
Default \code{TRUE}.}

\item{reducedDimName}{Saved dimension reduction name in \code{inSCE}.
Default \code{"UMAP"}.}

\item{xlab}{Character vector. Label for x-axis. Default \code{NULL}.}

\item{ylab}{Character vector. Label for y-axis. Default \code{NULL}.}

\item{dim1}{1st dimension to be used for plotting. Can either be a string
which specifies the name of the dimension to be plotted from reducedDims, or
a numeric value which specifies the index of the dimension to be plotted.
Default is \code{NULL}.}

\item{dim2}{2nd dimension to be used for plotting. Similar to \code{dim1}.
Default is \code{NULL}.}

\item{bin}{Numeric vector. If single value, will divide the numeric values
into \code{bin} groups. If more than one value, will bin numeric values using
values as a cut point. Default \code{NULL}.}

\item{binLabel}{Character vector. Labels for the bins created by \code{bin}.
Default \code{NULL}.}

\item{defaultTheme}{Removes grid in plot and sets axis title size to
\code{10} when \code{TRUE}. Default \code{TRUE}.}

\item{dotSize}{Size of dots. Default \code{0.5}.}

\item{summary}{Adds a summary statistic, as well as a crossbar to the
violin plot. Options are \code{"mean"} or \code{"median"}. Default
\code{NULL}.}

\item{summaryTextSize}{The text size of the summary statistic displayed
above the violin plot. Default \code{3}.}

\item{transparency}{Transparency of the dots, values will be 0-1. Default
\code{1}.}

\item{baseSize}{The base font size for all text. Default \code{12}.
Can be overwritten by \code{titleSize}, \code{axisSize}, and
\code{axisLabelSize}, \code{legendSize}, \code{legendTitleSize}.}

\item{titleSize}{Size of title of plot. Default \code{NULL}.}

\item{axisLabelSize}{Size of x/y-axis labels. Default \code{NULL}.}

\item{axisSize}{Size of x/y-axis ticks. Default \code{NULL}.}

\item{legendSize}{size of legend. Default \code{NULL}.}

\item{legendTitleSize}{size of legend title. Default \code{NULL}.}

\item{relHeights}{Relative heights of plots when combine is set. Default
\code{1}.}

\item{relWidths}{Relative widths of plots when combine is set. Default
\code{c(1, 1, 1)}.}

\item{plotNCols}{Number of columns when plots are combined in a grid. Default
\code{NULL}.}

\item{plotNRows}{Number of rows when plots are combined in a grid. Default
\code{NULL}.}

\item{labelSamples}{Will label sample name in title of plot if TRUE. Default
\code{TRUE}.}

\item{samplePerColumn}{If \code{TRUE}, when there are multiple samples and
combining by \code{"all"}, the output .ggplot will have plots from each
sample on a single column. Default \code{TRUE}.}

\item{sampleRelHeights}{If there are multiple samples and combining by
\code{"all"}, the relative heights for each plot. Default \code{1}.}

\item{sampleRelWidths}{If there are multiple samples and combining by
\code{"all"}, the relative widths for each plot. Default \code{1}.}
}
\value{
list of .ggplot objects
}
\description{
A wrapper function which visualizes outputs from the
\code{\link{runCxds}} function stored in the colData slot of the
\linkS4class{SingleCellExperiment} object via various plots.
}
\examples{
data(scExample, package="singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- runQuickUMAP(sce)
sce <- runCxds(sce)
plotCxdsResults(inSCE=sce, reducedDimName="UMAP")
}
\seealso{
\code{\link{runCxds}}
}
