% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/featureIndex.R
\name{featureIndex}
\alias{featureIndex}
\title{Retrieve row index for a set of features}
\usage{
featureIndex(
  features,
  inSCE,
  by = "rownames",
  exactMatch = TRUE,
  removeNA = FALSE,
  errorOnNoMatch = TRUE,
  warningOnPartialMatch = TRUE
)
}
\arguments{
\item{features}{Character vector of feature names to find in the rows of
\code{inSCE}.}

\item{inSCE}{A data.frame, matrix, or \linkS4class{SingleCellExperiment}
object to search.}

\item{by}{Character. Where to search for features in \code{inSCE}. If set to
\code{"rownames"} then the features will be searched for among
\code{rownames(inSCE)}. If \code{inSCE} inherits from class
\linkS4class{SummarizedExperiment}, then \code{by} can be one of the
fields in the row annotation data.frame (i.e. one of
\code{colnames(rowData(inSCE))}).}

\item{exactMatch}{Boolean. Whether to only identify exact matches
or to identify partial matches using \code{\link{grep}}.}

\item{removeNA}{Boolean. If set to \code{FALSE}, features not found in
\code{inSCE} will be given \code{NA} and the returned vector will be the same
length as \code{features}. If set to \code{TRUE}, then the \code{NA}
values will be removed from the returned vector. Default \code{FALSE}.}

\item{errorOnNoMatch}{Boolean. If \code{TRUE}, an error will be given if
no matches are found. If \code{FALSE}, an empty vector will be returned if 
\code{removeNA} is set to \code{TRUE} or a vector of \code{NA} if 
\code{removeNA} is set to \code{FALSE}. Default \code{TRUE}.}

\item{warningOnPartialMatch}{Boolean. If \code{TRUE}, a warning will be
given if some of the entries in \code{features} were not found in 
\code{inSCE}. The warning will list the features not found.
Default \code{TRUE}.}
}
\value{
A vector of row indices for the matching features in \code{inSCE}.
}
\description{
This will return indices of features among the rownames
or rowData of a data.frame, matrix, or a \linkS4class{SummarizedExperiment}
object including a \linkS4class{SingleCellExperiment}.
Partial matching (i.e. grepping) can be used by setting
\code{exactMatch = FALSE}.
}
\examples{
data(scExample)
ix <- featureIndex(features = c("MT-CYB", "MT-ND2"),
                             inSCE = sce,
                             by = "feature_name")
}
\seealso{
'\link[scater]{retrieveFeatureInfo}' from package \code{'scater'}
and \code{link{regex}} for how to use regular expressions when
\code{exactMatch = FALSE}.
}
\author{
Yusuke Koga, Joshua D. Campbell
}
