% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runSoupX.R
\name{runSoupX}
\alias{runSoupX}
\title{Detecting and correct contamination with SoupX}
\usage{
runSoupX(
  inSCE,
  sample = NULL,
  useAssay = "counts",
  background = NULL,
  bgAssayName = NULL,
  bgBatch = NULL,
  assayName = ifelse(is.null(background), "SoupX", "SoupX_bg"),
  cluster = NULL,
  reducedDimName = ifelse(is.null(background), "SoupX_UMAP_", "SoupX_bg_UMAP_"),
  tfidfMin = 1,
  soupQuantile = 0.9,
  maxMarkers = 100,
  contaminationRange = c(0.01, 0.8),
  rhoMaxFDR = 0.2,
  priorRho = 0.05,
  priorRhoStdDev = 0.1,
  forceAccept = FALSE,
  adjustMethod = c("subtraction", "soupOnly", "multinomial"),
  roundToInt = FALSE,
  tol = 0.001,
  pCut = 0.01
)
}
\arguments{
\item{inSCE}{A \linkS4class{SingleCellExperiment} object.}

\item{sample}{A single character specifying a name that can be found in
\code{colData(inSCE)} to directly use the cell annotation; or a character
vector with as many elements as cells to indicates which sample each cell
belongs to. SoupX will be run on cells from each sample separately. Default
\code{NULL}.}

\item{useAssay}{A single character string specifying which assay in
\code{inSCE} to use. Default \code{'counts'}.}

\item{background}{A numeric matrix of counts or a
\linkS4class{SingleCellExperiment} object with the matrix in \code{assay}
slot. It should have the same structure as \code{inSCE} except it contains
the matrix including empty droplets. Default \code{NULL}.}

\item{bgAssayName}{A single character string specifying which assay in
\code{background} to use when \code{background} is a
\linkS4class{SingleCellExperiment} object. If \code{NULL}, the function
will use the same value as \code{useAssay}. Default \code{NULL}.}

\item{bgBatch}{The same thing as \code{sample} but for \code{background}. Can
be a single character only when \code{background} is a
\linkS4class{SingleCellExperiment} object. Default \code{NULL}.}

\item{assayName}{A single character string of the output corrected matrix.
Default \code{"SoupX"} when not using a background, otherwise,
\code{"SoupX_bg"}.}

\item{cluster}{Prior knowledge of clustering labels on cells. A single
character string for specifying clustering label stored in
\code{colData(inSCE)}, or a character vector with as many elements as cells.
When not supplied, \code{\link[scran]{quickCluster}} method will be applied.}

\item{reducedDimName}{A single character string of the prefix of output
corrected embedding matrix for each sample. Default \code{"SoupX_UMAP_"} when
not using a background, otherwise, \code{"SoupX_bg_UMAP_"}.}

\item{tfidfMin}{Numeric. Minimum value of tfidf to accept for a marker gene.
Default \code{1}. See \code{?SoupX::autoEstCont}.}

\item{soupQuantile}{Numeric. Only use genes that are at or above this
expression quantile in the soup. This prevents inaccurate estimates due to
using genes with poorly constrained contribution to the background. Default
\code{0.9}. See \code{?SoupX::autoEstCont}.}

\item{maxMarkers}{Integer. If we have heaps of good markers, keep only the
best maxMarkers of them. Default \code{100}. See \code{?SoupX::autoEstCont}.}

\item{contaminationRange}{Numeric vector of two elements. This constrains
the contamination fraction to lie within this range. Must be between 0 and 1.
The high end of this range is passed to
\code{\link[SoupX]{estimateNonExpressingCells}} as
\code{maximumContamination}. Default \code{c(0.01, 0.8)}. See
\code{?SoupX::autoEstCont}.}

\item{rhoMaxFDR}{Numeric. False discovery rate passed to
\code{\link[SoupX]{estimateNonExpressingCells}}, to test if rho is less than
\code{maximumContamination}. Default \code{0.2}. See
\code{?SoupX::autoEstCont}.}

\item{priorRho}{Numeric. Mode of gamma distribution prior on contamination
fraction. Default \code{0.05}. See \code{?SoupX::autoEstCont}.}

\item{priorRhoStdDev}{Numeric. Standard deviation of gamma distribution prior
on contamination fraction. Default \code{0.1}. See
\code{?SoupX::autoEstCont}.}

\item{forceAccept}{Logical. Should we allow very high contamination fractions
to be used. Passed to \code{\link[SoupX]{setContaminationFraction}}. Default
\code{FALSE}. See \code{?SoupX::autoEstCont}.}

\item{adjustMethod}{Character. Method to use for correction. One of
\code{'subtraction'}, \code{'soupOnly'}, or \code{'multinomial'}. Default
\code{'subtraction'}. See \code{?SoupX::adjustCounts}.}

\item{roundToInt}{Logical. Should the resulting matrix be rounded to
integers? Default \code{FALSE}. See \code{?SoupX::adjustCounts}.}

\item{tol}{Numeric. Allowed deviation from expected number of soup counts.
Don't change this. Default \code{0.001}. See \code{?SoupX::adjustCounts}.}

\item{pCut}{Numeric. The p-value cut-off used when
\code{method = 'soupOnly'}. Default \code{0.01}. See
\code{?SoupX::adjustCounts}.}
}
\value{
The input \code{inSCE} object with \code{soupX_nUMIs},
\code{soupX_clustrers}, \code{soupX_contamination} appended to \code{colData}
slot; \code{soupX_{sample}_est} and \code{soupX_{sample}_counts} for each
sample appended to \code{rowData} slot; and other computational metrics at
\code{getSoupX(inSCE)}. Replace "soupX" to "soupX_bg" when \code{background}
is used.
}
\description{
A wrapper function for \link[SoupX]{autoEstCont} and
\link[SoupX]{adjustCounts}. Identify potential contamination from
experimental factors such as ambient RNA. Visit
\href{https://rawcdn.githack.com/constantAmateur/SoupX/204b602418df12e9fdb4b68775a8b486c6504fe4/inst/doc/pbmcTutorial.html}{their vignette}
for better understanding.
}
\examples{
\dontrun{
# SoupX does not work for toy example,
sce <- importExampleData("pbmc3k")
sce <- runSoupX(sce, sample = "sample")
plotSoupXResults(sce, sample = "sample")
}
}
\seealso{
plotSoupXResults
}
\author{
Yichen Wang
}
