% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seuratFunctions.R
\name{runSeuratFindHVG}
\alias{runSeuratFindHVG}
\title{runSeuratFindHVG
Find highly variable genes and store in the input sce object}
\usage{
runSeuratFindHVG(
  inSCE,
  useAssay = "counts",
  method = c("vst", "dispersion", "mean.var.plot"),
  hvgNumber = 2000,
  createFeatureSubset = "hvf",
  altExp = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{inSCE}{(sce) object to compute highly variable genes from and to store
back to it}

\item{useAssay}{Specify the name of the assay to use for computation
of variable genes. It is recommended to use a raw counts assay with the
\code{"vst"} method and normalized assay with all other methods. Default
is \code{"counts"}.}

\item{method}{selected method to use for computation of highly variable
genes. One of \code{'vst'}, \code{'dispersion'}, or \code{'mean.var.plot'}.
Default \code{"vst"} which uses the raw counts. All other methods use
normalized counts.}

\item{hvgNumber}{numeric value of how many genes to select as highly
variable. Default \code{2000}}

\item{createFeatureSubset}{Specify a name of the subset to create
for the identified variable features. Default is \code{"hvf"}.
Leave it \code{NULL} if you do not want to create a subset of
variable features.}

\item{altExp}{Logical value indicating if the input object is an
altExperiment. Default \code{FALSE}.}

\item{verbose}{Logical value indicating if informative messages should
be displayed. Default is \code{TRUE}.}
}
\value{
Updated \code{SingleCellExperiment} object with highly variable genes
computation stored
}
\description{
runSeuratFindHVG
Find highly variable genes and store in the input sce object
}
\examples{
data(scExample, package = "singleCellTK")
sce <- runSeuratFindHVG(sce)
}
\seealso{
\code{\link{runFeatureSelection}}, \code{\link{runModelGeneVar}},
\code{\link{getTopHVG}}, \code{\link{plotTopHVG}}
}
