% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotTopHVG.R
\name{plotTopHVG}
\alias{plotTopHVG}
\title{Plot highly variable genes}
\usage{
plotTopHVG(
  inSCE,
  method = "modelGeneVar",
  hvgNumber = 2000,
  useFeatureSubset = NULL,
  labelsCount = 10,
  featureDisplay = metadata(inSCE)$featureDisplay,
  labelSize = 2,
  dotSize = 2,
  textSize = 12
)
}
\arguments{
\item{inSCE}{Input \code{SingleCellExperiment} object containing the
computations.}

\item{method}{Select either \code{"vst"}, \code{"mean.var.plot"},
\code{"dispersion"} or \code{"modelGeneVar"}.}

\item{hvgNumber}{Specify the number of top genes to highlight in red. Default
\code{2000}. See details.}

\item{useFeatureSubset}{A character string for the \code{rowData} variable
name to store a logical index of selected features. Default \code{NULL}. See
details.}

\item{labelsCount}{Specify the number of data points/genes to label. Should
be less than \code{hvgNumber}. Default \code{10}. See details.}

\item{featureDisplay}{A character string for the \code{rowData} variable name
to indicate what type of feature ID should be displayed. If set by
\code{\link{setSCTKDisplayRow}}, will by default use it. If \code{NULL}, will
use \code{rownames(inSCE)}.}

\item{labelSize}{Numeric, size of the text label on top HVGs. Default 
\code{2}.}

\item{dotSize}{Numeric, size of the dots of the features. Default \code{2}.}

\item{textSize}{Numeric, size of the text of axis title, axis label, etc.
Default \code{12}.}
}
\value{
ggplot of HVG metrics and top HVG labels
}
\description{
Plot highly variable genes
}
\details{
When \code{hvgNumber = NULL} and \code{useFeature = NULL}, only plot
the mean VS variance/dispersion scatter plot. When only \code{hvgNumber} set,
label the top \code{hvgNumber} HVGs ranked by the metrics calculated by
\code{method}. When \code{useFeatureSubset} set, label the features in
the subset on the scatter plot created with \code{method} and ignore
\code{hvgNumber}.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runModelGeneVar(mouseBrainSubsetSCE)
plotTopHVG(mouseBrainSubsetSCE, method = "modelGeneVar")
}
\seealso{
\code{\link{runFeatureSelection}}, \code{\link{runSeuratFindHVG}},
\code{\link{runModelGeneVar}}, \code{\link{getTopHVG}}
}
