% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/sampleSummaryStats.R
\name{listSampleSummaryStatsTables}
\alias{listSampleSummaryStatsTables}
\alias{listSampleSummaryStatsTables,SingleCellExperiment-method}
\title{Lists the table of SCTK QC outputs stored within the metadata.}
\usage{
listSampleSummaryStatsTables(inSCE, ...)

\S4method{listSampleSummaryStatsTables}{SingleCellExperiment}(inSCE, ...)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object with saved
table within the \link{metadata} data. Required.}

\item{...}{Other arguments passed to the function.}
}
\value{
A character vector. Contains a list of summary tables
within the SingleCellExperiment object.
}
\description{
Returns a character vector of the tables
within the metadata slot of the SingleCellExperiment object.
}
\examples{
data(scExample, package = "singleCellTK")
sce <- subsetSCECols(sce, colData = "type != 'EmptyDroplet'")
sce <- sampleSummaryStats(sce, simple = TRUE, statsName = "qc_table")
listSampleSummaryStatsTables(sce)
}
