% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getTopHVG.R
\name{getTopHVG}
\alias{getTopHVG}
\alias{setTopHVG}
\title{Get or set top HVG after calculation}
\usage{
getTopHVG(
  inSCE,
  method = c("vst", "dispersion", "mean.var.plot", "modelGeneVar", "seurat", "seurat_v3",
    "cell_ranger"),
  hvgNumber = 2000,
  useFeatureSubset = "hvf",
  featureDisplay = metadata(inSCE)$featureDisplay
)

setTopHVG(
  inSCE,
  method = c("vst", "dispersion", "mean.var.plot", "modelGeneVar", "seurat", "seurat_v3",
    "cell_ranger"),
  hvgNumber = 2000,
  featureSubsetName = "hvg2000",
  genes = NULL,
  genesBy = NULL,
  altExp = FALSE
)
}
\arguments{
\item{inSCE}{Input \linkS4class{SingleCellExperiment} object}

\item{method}{Specify which method to use for variable gene extraction
from Seurat \code{"vst"}, \code{"mean.var.plot"}, \code{"dispersion"} or
Scran \code{"modelGeneVar"} or Scanpy \code{"seurat"}, \code{"cell_ranger"}, 
\code{"seurat_v3"}. Default \code{"vst"}}

\item{hvgNumber}{Specify the number of top variable genes to extract.}

\item{useFeatureSubset}{Get the feature names in the HVG list set by
\code{setTopHVG}. \code{method} and \code{hvgNumber} will not be used if not
this is not \code{NULL}. Default \code{"hvf"}.}

\item{featureDisplay}{A character string for the \code{rowData} variable name
to indicate what type of feature ID should be displayed. If set by
\code{\link{setSCTKDisplayRow}}, will by default use it. If \code{NULL}, will
use \code{rownames(inSCE)}.}

\item{featureSubsetName}{A character string for the \code{rowData} variable
name to store a logical index of selected features. Default \code{"hvg2000"}.}

\item{genes}{A customized character vector of gene list to be set as a
\code{rowData} variable. Will ignore \code{method} and \code{hvgNumber} if
set. Default \code{NULL}.}

\item{genesBy}{If setting customized \code{genes}, where should it be found
in \code{rowData}? Leave \code{NULL} for matching \code{rownames}. Default
\code{NULL}.}

\item{altExp}{\code{TRUE} for also creating a subset \code{inSCE} object with
the selected HVGs and store this subset in the \code{altExps} slot, named by
\code{hvgListName}. Default \code{FALSE}.}
}
\value{
\item{getTopHVG}{A character vector of the top \code{hvgNumber} variable
feature names}
\item{setTopHVG}{The input \code{inSCE} object with the logical vector of
HVG selection updated in \code{rowData}, and related parameter updated in
\code{metadata}. If \code{altExp} is \code{TRUE}, an \code{altExp} is also
added}
}
\description{
Extracts or select the top variable genes from an input
\linkS4class{SingleCellExperiment} object. Note that the variability metrics
must be computed using the \code{runFeatureSelection} method before
extracting the feature names of the top variable features. \code{getTopHVG}
only returns a character vector of the HVG selection, while with
\code{setTopHVG}, a logical vector of the selection will be saved in the
\code{rowData}, and optionally, a subset object for the HVGs can be stored
in the \code{altExps} slot at the same time.
}
\examples{
data("scExample", package = "singleCellTK")

# Create a "highy variable feature" subset using Seurat's vst method:
sce <- runSeuratFindHVG(sce,  method = "vst", hvgNumber = 2000,
       createFeatureSubset = "hvf")
       
# Get the list of genes for a feature subset:
hvgs <- getTopHVG(sce, useFeatureSubset = "hvf")

# Create a new feature subset on the fly without rerunning the algorithm:
sce <- setTopHVG(sce, method = "vst", hvgNumber = 100,
                featureSubsetName = "hvf100")
hvgs <- getTopHVG(sce, useFeatureSubset = "hvf100")

# Get a list of variable features without creating a new feature subset:
hvgs <- getTopHVG(sce, useFeatureSubset = NULL,
                  method = "vst", hvgNumber = 10)

}
\seealso{
\code{\link{runFeatureSelection}}, \code{\link{runSeuratFindHVG}},
\code{\link{runModelGeneVar}}, \code{\link{plotTopHVG}}
}
\author{
Irzam Sarfraz, Yichen Wang
}
