% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/runFindMarker.R
\name{getFindMarkerTopTable}
\alias{getFindMarkerTopTable}
\alias{findMarkerTopTable}
\title{Fetch the table of top markers that pass the filtering}
\usage{
getFindMarkerTopTable(
  inSCE,
  log2fcThreshold = 0,
  fdrThreshold = 0.05,
  minClustExprPerc = 0.5,
  maxCtrlExprPerc = 0.5,
  minMeanExpr = 0,
  topN = 1
)

findMarkerTopTable(
  inSCE,
  log2fcThreshold = 1,
  fdrThreshold = 0.05,
  minClustExprPerc = 0.7,
  maxCtrlExprPerc = 0.4,
  minMeanExpr = 1,
  topN = 10
)
}
\arguments{
\item{inSCE}{\linkS4class{SingleCellExperiment} inherited object.}

\item{log2fcThreshold}{Only use DEGs with the absolute values of log2FC
larger than this value. Default \code{1}}

\item{fdrThreshold}{Only use DEGs with FDR value smaller than this value.
Default \code{0.05}}

\item{minClustExprPerc}{A numeric scalar. The minimum cutoff of the
percentage of cells in the cluster of interests that expressed the marker
gene. Default \code{0.7}.}

\item{maxCtrlExprPerc}{A numeric scalar. The maximum cutoff of the
percentage of cells out of the cluster (control group) that expressed the
marker gene. Default \code{0.4}.}

\item{minMeanExpr}{A numeric scalar. The minimum cutoff of the mean
expression value of the marker in the cluster of interests. Default \code{1}.}

\item{topN}{An integer. Only to fetch this number of top markers for each
cluster in maximum, in terms of log2FC value. Use \code{NULL} to cancel the
top N subscription. Default \code{10}.}
}
\value{
An organized \code{data.frame} object, with the top marker gene
information.
}
\description{
Fetch the table of top markers that pass the filtering
}
\details{
Users have to run \code{\link{runFindMarker}} prior to using this
function to extract a top marker table.
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- runFindMarker(mouseBrainSubsetSCE,
                                     useAssay = "logcounts",
                                     cluster = "level1class")
getFindMarkerTopTable(mouseBrainSubsetSCE)
}
\seealso{
\code{\link{runFindMarker}}, \code{\link{plotFindMarkerHeatmap}}
}
