% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abundance.R
\name{diffAbundanceFET}
\alias{diffAbundanceFET}
\title{Calculate Differential Abundance with FET}
\usage{
diffAbundanceFET(inSCE, cluster, variable, control, case, analysisName)
}
\arguments{
\item{inSCE}{A \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object.}

\item{cluster}{A single \code{character}, specifying the name to store the
cluster label in \code{\link{colData}}.}

\item{variable}{A single \code{character}, specifying the name to store the
phenotype labels in \code{\link{colData}}.}

\item{control}{\code{character}. Specifying one or more categories that can
be found in the vector specified by \code{variable}.}

\item{case}{\code{character}. Specifying one or more categories that can
be found in the vector specified by \code{variable}.}

\item{analysisName}{A single \code{character}. Will be used for naming the
result table, which will be saved in metadata slot.}
}
\value{
The original \code{\link[SingleCellExperiment]{SingleCellExperiment}}
object with \code{metadata(inSCE)} updated with a list
\code{diffAbundanceFET}, containing a new \code{data.frame} for the analysis
result, named by \code{analysisName}. The \code{data.frame} contains columns
for number and fraction of cells that belong to different cases, as well as
"Odds_Ratio", "PValue" and "FDR".
}
\description{
Calculate Differential Abundance with FET
}
\details{
This function will calculate the cell counting and fraction by
dividing all cells to groups specified by the arguments, together with
statistical summary by performing Fisher Exact Tests (FET).
}
\examples{
data("mouseBrainSubsetSCE", package = "singleCellTK")
mouseBrainSubsetSCE <- diffAbundanceFET(inSCE = mouseBrainSubsetSCE,
                                                cluster = "tissue",
                                                variable = "level1class",
                                                case = "oligodendrocytes",
                                                control = "microglia",
                                                analysisName = "diffAbundFET")
}
