% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscFunctions.R
\name{dedupRowNames}
\alias{dedupRowNames}
\title{Deduplicate the rownames of a matrix or SingleCellExperiment object}
\usage{
dedupRowNames(x, as.rowData = FALSE, return.list = FALSE)
}
\arguments{
\item{x}{A matrix like or \linkS4class{SingleCellExperiment} object, on which
we can apply \code{rownames()} to and has duplicated rownames.}

\item{as.rowData}{Only applicable when \code{x} is a
\linkS4class{SingleCellExperiment} object. When set to \code{TRUE}, will
insert a new column called \code{"rownames.uniq"} to \code{rowData(x)}, with
the deduplicated rownames.}

\item{return.list}{When set to \code{TRUE}, will return a character vector
of the deduplicated rownames.}
}
\value{
By default, a matrix or \linkS4class{SingleCellExperiment} object
with rownames deduplicated.
When \code{x} is a \linkS4class{SingleCellExperiment} and \code{as.rowData}
is set to \code{TRUE}, will return \code{x} with \code{rowData} updated.
When \code{return.list} is set to \code{TRUE}, will return a character vector
with the deduplicated rownames.
}
\description{
Adds '-1', '-2', ... '-i' to multiple duplicated rownames, and in place
replace the unique rownames, store unique rownames in \code{rowData}, or
return the unique rownames as character vecetor.
}
\examples{
data("scExample", package = "singleCellTK")
sce <- dedupRowNames(sce)
}
