% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constructor.R
\name{create_ontology_DAG}
\alias{create_ontology_DAG}
\title{Create the ontology_DAG object}
\usage{
create_ontology_DAG(
  parents,
  children,
  relations = NULL,
  relations_DAG = NULL,
  source = "Ontology",
  annotation = NULL,
  remove_cyclic_paths = FALSE,
  remove_rings = FALSE,
  alternative_terms = list(),
  verbose = simona_opt$verbose
)
}
\arguments{
\item{parents}{A character vector of parent terms. You can also construct the \code{ontology_DAG} object by a list of parent-child links. See \strong{Examples}.}

\item{children}{A character vector of child terms.}

\item{relations}{A character vector of parent-child relations, e.g. "is_a", "part_of", or self-defined semantic relations.
If it is set, it should have the same length as \code{parents} and \code{children}.}

\item{relations_DAG}{If the relation types have hierarchical relations, it can also be constructed by \code{create_ontology_DAG()} first. See \strong{Examples}.
When the DAG for relation types is provided, the ancestor/offspring relationship of relation types will be taken into consideration automatically.}

\item{source}{Source of the ontology. It is only used as a label of the object.}

\item{annotation}{A list of character vectors which contain items annotated to the terms. Names of the list should be the term names. In the DAG, items
annotated to a term will also be annotated to its parents. Such merging
is applied automatically in the package.}

\item{remove_cyclic_paths}{Whether to remove cyclic paths If a cyclic path is represented as \verb{[a, b, ..., z, a]},
the last link (i.e. \code{z->a}) is simply removed. If the value is set to \code{FALSE} and if there are cyclic paths, there
will be an error that lists all cyclic paths.}

\item{remove_rings}{There might be rings that are isolated to the main DAG where there are no roots on the rings, thus they cannot be attached to the main DAG. If the value
of \code{remove_rings} is set to \code{TRUE}, such rings are removed.}

\item{alternative_terms}{A named list or vector that contains mappings from alternative term IDs to terms used in the DAG. In an ontology, there
might be old terms IDs marked as "replaced_by", "consider" or "alt_id" in ".obo" file. You can provide mappings from old term iDs to current term IDs with this argument.
If it is a one-to-one mapping, the mapping
can be a named vector where alternative term IDs are names and DAG term IDs are values. It it is a one-to-many mapping, the variable
should be a named list where each member vector will first be matched to the DAG terms. If the mapping is still one-to-many, the first one is selected.}

\item{verbose}{Whether to print messages.}
}
\value{
An \code{ontology_DAG} object.
}
\description{
Create the ontology_DAG object
}
\examples{
parents  = c("a", "a", "b", "b", "c", "d")
children = c("b", "c", "c", "d", "e", "f")
dag = create_ontology_DAG(parents, children)

# with annotations
annotation = list(
    "a" = c("t1", "t2", "t3"),
    "b" = c("t3", "t4"),
    "c" = "t5",
    "d" = "t7",
    "e" = c("t4", "t5", "t6", "t7"),
    "f" = "t8"
)
dag = create_ontology_DAG(parents, children, annotation = annotation)

# with relations
dag = create_ontology_DAG(parents, children, 
    relations = c("is_a", "part_of", "is_a", "part_of", "is_a", "part_of"))

# with relations_DAG
relations_DAG = create_ontology_DAG(c("r2", "r2"), c("r3", "r4"))
dag = create_ontology_DAG(parents, children, 
    relations = c("r1", "r2", "r1", "r3", "r1", "r4"),
    relations_DAG = relations_DAG)

# with a list of parent-child relations
dag = create_ontology_DAG(c("a-b", "a-c", "b-c", "b-d", "c-e", "e-f"))
}
