% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plots.R
\name{ridgelineSignPlot}
\alias{ridgelineSignPlot}
\title{Ridgeline Plot}
\usage{
ridgelineSignPlot(
  data,
  whichSign = NULL,
  groupByAnnot = NULL,
  selectByAnnot = NULL,
  ...
)
}
\arguments{
\item{data}{an object of type \linkS4class{SummarizedExperiment}. Output of
the signatures functions.}

\item{whichSign}{character vector saying the signatures to plot. If not
specified, all the signatures inside data will be plotted. Other signatures
not computed with signifinder can be added in the vector if they are also
included in che colData section of data.}

\item{groupByAnnot}{character vector containing samples' annotations.}

\item{selectByAnnot}{character string saying the subgroup from `groupByAnnot`
used to compute the ridgeline plot.}

\item{...}{other parameters specific of the functions
\code{\link[ggridges]{geom_density_ridges}} and
\code{\link[ggridges]{geom_density_ridges_gradient}}.}
}
\value{
A \code{\link[ggplot2]{ggplot}} object.
}
\description{
Given multiple signatures, the function plots scores density distribution.
}
\examples{
data(ovse)
ridgelineSignPlot(data = ovse)

}
