% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_targets.R
\name{get_targets}
\alias{get_targets}
\title{Target Gene/Protein IDs for Query Drugs}
\usage{
get_targets(drugs, database = "all", verbose = TRUE, output = "df")
}
\arguments{
\item{drugs}{character vector of drug names}

\item{database}{drug-target annotation resource; A character vector of any
combination of 'DrugBank', 'CLUE', STITCH' or 'all'. The target set from
the selected resources will be combined. If 'all' is contained in the 
character vector, target sets from all of the annotation databases
(DrugBank, CLUE and STITCH) will be combined.}

\item{verbose}{TRUE or FALSE, whether to print messages}

\item{output}{one of "df", "list" or "vector". If setting as "df", the result 
is in a data.frame format containing target gene symbols separated by semicolon
for each drug. If setting as "list", the result is a list of targets for each
query drug. If setting as "vector", the result is a character vector of the 
target set that are collapsed with duplications if different drugs 
have the same targets.}
}
\value{
drug-target annotation in a format defined by the \code{output} argument.
}
\description{
This function returns for a set of query drug names/ids the corresponding
target gene/protein ids. The required drug-target annotations are from
DrugBank, CLUE and STITCH. An SQLite database storing these drug-target
interactions based on the above three annotation resources is available in 
the \code{\link[signatureSearchData]{signatureSearchData}} package.
}
\examples{
data(drugs10)
dt <- get_targets(drugs10)
}
\seealso{
\code{\link[signatureSearchData]{dtlink_db_clue_sti}}
}
