% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessor.R
\docType{methods}
\name{dim}
\alias{dim}
\alias{dim,gessResult-method}
\alias{dim,feaResult-method}
\title{Dimensions of an Object}
\usage{
\S4method{dim}{gessResult}(x)

\S4method{dim}{feaResult}(x)
}
\arguments{
\item{x}{an R object}
}
\value{
dim attribute of the result table
}
\description{
Retrieve dimension of the result table in the \code{\link{gessResult}}, 
and \code{\link{feaResult}} objects
}
\examples{
gr <- gessResult(result=dplyr::tibble(pert=letters[seq_len(10)], 
                                      val=seq_len(10)), 
                 query=list(up=c("g1","g2"), down=c("g3","g4")),
                 gess_method="LINCS", refdb="path/to/lincs/db")
dim(gr)
fr <- feaResult(result=dplyr::tibble(id=letters[seq_len(10)], 
                                     val=seq_len(10)),
                organism="human", ontology="MF", drugs=c("d1", "d2"), 
                targets=c("t1","t2"))
dim(fr)
}
