% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-uploader.R
\name{get_uploader}
\alias{get_uploader}
\alias{misc_get_uploader}
\title{Download Seven Bridges command line uploader and extract to
a specified directory}
\usage{
get_uploader(
  platform = c("cgc", "aws-us", "aws-eu", "gcp"),
  destdir = NULL,
  quiet = FALSE
)

misc_get_uploader()
}
\arguments{
\item{platform}{Seven Bridges platform for which the uploader
is designed. Possible choices are:
\code{"cgc"} (Cancer Genomics Cloud),
\code{"aws-us"} (Amazon Web Services US),
\code{"aws-eu"} (Amazon Web Services EU),
and \code{"gcp"} (Google Cloud Platform).
Default is \code{"cgc"}.}

\item{destdir}{The directory to extract the downloaded Seven Bridges
command line uploader to. If the specified directory is not present,
it will be created.}

\item{quiet}{Should the download progress be printed?}
}
\value{
\code{0} if the command line uploader is successfully
downloaded and unarchived.
}
\description{
This function downloads Seven Bridges command line uploader and
extract the \code{.tgz} archive to a specified directory.
}
\examples{
# Download CGC CLI uploader to `~/Downloads`
dir <- "~/Downloads/"
\dontrun{
get_uploader("cgc", dir)}
}
\references{
\url{https://docs.sevenbridges.com/docs/upload-via-the-command-line}
}
