% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-http.R
\name{api}
\alias{api}
\title{Core HTTP logic for Seven Bridges API}
\usage{
api(
  token = NULL,
  version = "v2",
  path = NULL,
  method = c("GET", "POST", "PUT", "DELETE", "PATCH"),
  query = NULL,
  body = list(),
  encode = c("json", "form", "multipart"),
  limit = getOption("sevenbridges")$limit,
  offset = getOption("sevenbridges")$offset,
  advance_access = getOption("sevenbridges")$advance_access,
  authorization = FALSE,
  fields = NULL,
  base_url = paste0("https://api.sbgenomics.com/", version, "/"),
  ...
)
}
\arguments{
\item{token}{API auth token or \code{access_token} for
Seven Bridges single sign-on.}

\item{version}{API version number, default is \code{v2}.}

\item{path}{path connected with \code{base_url}.}

\item{method}{one of \code{"GET"}, \code{"POST"},
\code{"PUT"}, or \code{"Delete"}.}

\item{query}{Passed to httr package GET/POST call.}

\item{body}{Passed to httr package GET/POST/PUT/DELETE call.}

\item{encode}{If the body is a named list, how should it be
encoded? Can be one of \code{"json"} (application/json),
\code{"form"} (application/x-www-form-urlencoded),
or \code{"multipart"} (multipart/form-data).
Default is \code{"json"}.
For \code{"multipart"}, list elements can be strings
or objects created by \code{\link[httr]{upload_file}}.
For "form", elements are coerced to strings and escaped,
use \code{I()} to prevent double-escaping.
For \code{"json"}, parameters are automatically "unboxed"
(i.e. length 1 vectors are converted to scalars). To preserve
a length 1 vector as a vector, wrap in \code{I()}.}

\item{limit}{How many results to return}

\item{offset}{The point at which to start displaying them}

\item{advance_access}{Enable advance access features?
Default is \code{FALSE}.}

\item{authorization}{Logical. Is the \code{token} an API
auth token (\code{FALSE}) or an access token from the
Seven Bridges single sign-on (\code{TRUE})?}

\item{fields}{All API calls take the optional query parameter fields.
This parameter enables you to specify the fields you want to be returned
when listing resources (e.g. all your projects) or getting details of a
specific resource (e.g. a given project). For example, fields="id,name,size"
to return the fields id, name and size for files. More details please check
\url{https://docs.sevenbridges.com/docs/the-api#section-general-api-information}}

\item{base_url}{defeault is \code{"https://api.sbgenomics.com/v2"}}

\item{...}{passed to GET/POST/PUT/DELETE/PATCH call.}
}
\value{
returned request list of httr
}
\description{
Core HTTP logic for Seven Bridges API
}
\details{
Used for advanced users and the core method for higher level API
in this package, please refer to the easy api vignette and
additional vignettes pages for more convenient usage.
}
\examples{
token <- "your_token"
# list projects
\dontrun{
api(token = token, path = "projects", method = "GET")}
}
\references{
\url{https://docs.sevenbridges.com/v1.0/page/api}
}
